/* This simple program toggles the sensitive second bytes for ChiTeX
   with latex2html.

   Coded by: Hung-Yih Chen () July 9, 1999
             modified from chicode.c which is created by
             Prof. shann ()
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int checkarg(char []);

int main (int argc, char *argv[]) {
    int i=0, c, flag_chi=0, flag_stdin=1, flag_u=0;
    char *fname, *fnametex;
    FILE *fp;

    switch(argc) {
    case 1:
	fp = stdin;
	break;
    case 2:
	if (argv[1][0] == '-') {
	    if (checkarg(argv[1])) {
		flag_u = 1;
		fp = stdin;
	    }
	    else {
		fprintf(stderr, "Usage: %s [-u] [filename]\n", argv[0]);
		exit(1);
	    }
	}
	else {
	    flag_stdin=0;
	    fname = argv[1];
	}
	break;
    case 3:
	if (checkarg(argv[1])) {
	    flag_u = 1;
	    flag_stdin=0;
	    fname = argv[2];
	}
	else {
	    fprintf(stderr, "Usage: %s [-u] [filename]\n", argv[0]);
	    exit(1);
	}
	break;
    default:
	fprintf(stderr, "Usage: %s [-u] [filename]\n", argv[0]);
	exit(1);
	break;
    }

    if (!flag_stdin) {
	fp = fopen(fname, "r");
        if (fp == NULL) {
	    if (strchr(fname, '.') == NULL) {
		fnametex = (char *) malloc(strlen(fname)+5);
		while (fname[i] != '\0') {
		    fnametex[i] = fname[i];
		    ++i;
		}
		fnametex[i++] = '.';
		fnametex[i++] = 't';
		fnametex[i++] = 'e';
		fnametex[i++] = 'x';
		fnametex[i++] = '\0';
		fclose(fp);
		fp = fopen(fnametex, "r");
		if (fp == NULL) {
		    fprintf(stderr, "%s[.tex] not opened.\n", fname);
		    exit(-1);
		}
	    }
	    else {
		fprintf(stderr, "%s not opened.\n", fname);
		exit(-1);
	    }
        }
    }
	
    while ((c = getc(fp)) != EOF) {
	if (!flag_chi) {
	    if ((c < 250) && (c > 160))
		flag_chi = 1;
	}
	else {
	    switch(c) {
/*	    case '\\':
		c = 128;
		break;       */
	    case '\\':
		c = 159;
		break;       
	    case 91:
		c = 158;
		break;       
	    case 93:
		c = 160;
		break;       
	    case '{':
		c = 155;
		break;
	    case '|':
		c = 156;
		break;
	    case '}':
		c = 157;
		break;
	    case '~':
		c = 128;
		break;
	    case 159:
		c = '\\';
		break;
	    case 158:
		c = 91;
		break;       
	    case 160:
		c = 93;
		break;       
	    case 155:
		c = '{';
		break;
	    case 156:
		c = '|';
		break;
	    case 157:
		c = '}';
		break;
	    case 128:
		c = '~';
		break;
	    default:
		if (flag_u) {
		    if ((c > 128) && (c < 155))		    
			c = c - 129 + 'a';            
		}
		break;
	    }
	    flag_chi = 0;
	}
	printf("%c", c);
    }
    fclose(fp);
    return 0;
}

int checkarg(char s[]) {
    if (s[0] == '-') {
	if (s[1] == 'u')
	    return 1;
	else
	    return 0;
    }
    else
	return 0;
}

