//////////////////////////////////////////////////////////////////////
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
//  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
//  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//  PARTICULAR PURPOSE.
//
//  Copyright (C) 2003  Microsoft Corporation.  All rights reserved.
//
//  KeyEventSink.cpp
//
//          ITfKeyEventSink implementation.
//
//////////////////////////////////////////////////////////////////////

#include "Globals.h"
#include "TextService.h"
#include "CandidateList.h"
#include "ime-key.h"
#include "gcin-im-client.h"

extern UINT FAKE_KEY;


//+---------------------------------------------------------------------------
//
// _IsKeyEaten
//
//----------------------------------------------------------------------------

HWND get_hwnd(CTextService *_pTextService);

BOOL CTextService::_IsKeyEaten(ITfContext *pContext, WPARAM wParam, LPARAM lParam)
{
#if 0
    // if the keyboard is disabled, keys are not consumed.
	if (_IsKeyboardDisabled()) {
		dbg("disabled\n");
        return FALSE;
	}
#endif

	if (wParam==FAKE_KEY)
		return TRUE;

#if 0
    // if the keyboard is closed, keys are not consumed.
	if (!_IsKeyboardOpen()) {
		dbg("open\n");
        return FALSE;
	}
#endif
 if (!handle) {
		handle = gcin_im_client_open(NULL);
		if (!handle) {
			dbg("failed to connect\n");
			return FALSE;
		}
  }


	BYTE keystate[256];
	GetKeyboardState(keystate);

	BOOL ret = send_gcin_key(handle, wParam, GetKeyInfo(lParam), keystate, NULL);

#if 0
	if (!ret) {
		bool o_has_comp = _IsComposing();
		char *gcompstr = NULL;
		GCIN_PREEDIT_ATTR gcin_att[256];
		int cursorpos=0;
		int gcin_attN = gcin_im_client_get_preedit(handle, &gcompstr, gcin_att, &cursorpos);
		bool n_has_comp = gcompstr && gcompstr[0];
		free(gcompstr);

		if (o_has_comp && !n_has_comp) {
//			set_composition_text(ec, pContext, "");
			_EndComposition(pContext);
		}
	}
#endif

	dbg("_IsKeyEaten %d\n", ret);
	return ret;
}


//+---------------------------------------------------------------------------
//
// OnSetFocus
//
// Called by the system whenever this service gets the keystroke device focus.
//----------------------------------------------------------------------------

STDAPI CTextService::OnSetFocus(BOOL fForeground)
{
	dbg("OnSetFocus %d\n", fForeground);
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// OnTestKeyDown
//
// Called by the system to query this service wants a potential keystroke.
//----------------------------------------------------------------------------

STDAPI CTextService::OnTestKeyDown(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten)
{
	dbg("----- OnTestKeyDown\n");
#if 1
    *pfEaten = _IsKeyEaten(pContext, wParam, lParam);
#else
	*pfEaten = true;
#endif
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// OnKeyDown
//
// Called by the system to offer this service a keystroke.  If *pfEaten == TRUE
// on exit, the application will not handle the keystroke.
//----------------------------------------------------------------------------
inline bool IsKeyDown(BYTE keystate){ return !!(keystate & 0xF0); }

STDAPI CTextService::OnKeyDown(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten)
{
    *pfEaten = _IsKeyEaten(pContext, wParam, lParam);
#if 0

	dbg("OnKeyDown %d\n", *pfEaten);

	KeyInfo ki = GetKeyInfo(lParam);
	BYTE keystate[256];
	GetKeyboardState(keystate);


	char asc=0;
	char ascii[4];
	ZeroMemory(ascii, sizeof(ascii));
	int ret = ToAscii(wParam, ki.scanCode, (BYTE*)keystate, (LPWORD)ascii, 0);

	dbg("CTextService::OnKeyDown key:%x asc:%s %d\n", wParam, ascii, *pfEaten);
#endif

    if (*pfEaten)
    {
        _InvokeKeyHandler(pContext, wParam, lParam);
    }
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// OnTestKeyUp
//
// Called by the system to query this service wants a potential keystroke.
//----------------------------------------------------------------------------

STDAPI CTextService::OnTestKeyUp(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten)
{
	dbg("OnTestKeyUp\n");
#if 1
    *pfEaten = _IsKeyEaten(pContext, wParam, lParam);
#else
	*pfEaten = true;
#endif

    return S_OK;
}

//+---------------------------------------------------------------------------
//
// OnKeyUp
//
// Called by the system to offer this service a keystroke.  If *pfEaten == TRUE
// on exit, the application will not handle the keystroke.
//----------------------------------------------------------------------------

STDAPI CTextService::OnKeyUp(ITfContext *pContext, WPARAM wParam, LPARAM lParam, BOOL *pfEaten)
{
	dbg("OnKeyUp\n");
 //   *pfEaten = _IsKeyEaten(pContext, wParam);
	if (!handle)
		return S_FALSE;

	BYTE keystate[256];
	GetKeyboardState(keystate);

	char *rstr=NULL;
	BOOL ret = send_gcin_key(handle, wParam, GetKeyInfo(lParam), keystate, &rstr);

	if (rstr) {
//		send_text(ec, pContext, rstr);
		free(rstr);
	}

	if (!ret)
		return FALSE;

#if 1
	_InvokeKeyReleaseHandler(pContext, wParam, lParam);
#endif

    return TRUE;
}

//+---------------------------------------------------------------------------
//
// OnPreservedKey
//
// Called when a hotkey (registered by us, or by the system) is typed.
//----------------------------------------------------------------------------

STDAPI CTextService::OnPreservedKey(ITfContext *pContext, REFGUID rguid, BOOL *pfEaten)
{
    return S_OK;
}

//+---------------------------------------------------------------------------
//
// _InitKeyEventSink
//
// Advise a keystroke sink.
//----------------------------------------------------------------------------

BOOL CTextService::_InitKeyEventSink()
{
    ITfKeystrokeMgr *pKeystrokeMgr;
    HRESULT hr;
//	dbg("CTextService::_InitKeyEventSink\n");

    if (_pThreadMgr->QueryInterface(IID_ITfKeystrokeMgr, (void **)&pKeystrokeMgr) != S_OK)
        return FALSE;

    hr = pKeystrokeMgr->AdviseKeyEventSink(_tfClientId, (ITfKeyEventSink *)this, TRUE);

    pKeystrokeMgr->Release();

    return (hr == S_OK);
}

//+---------------------------------------------------------------------------
//
// _UninitKeyEventSink
//
// Unadvise a keystroke sink.  Assumes a sink has been advised already.
//----------------------------------------------------------------------------

void CTextService::_UninitKeyEventSink()
{
    ITfKeystrokeMgr *pKeystrokeMgr;

    if (_pThreadMgr->QueryInterface(IID_ITfKeystrokeMgr, (void **)&pKeystrokeMgr) != S_OK)
        return;

    pKeystrokeMgr->UnadviseKeyEventSink(_tfClientId);

    pKeystrokeMgr->Release();
}