#include "globals.h"
#include "TextService.h"

BOOL
CTextService::_InitThreadFocusSink() {
    HRESULT hr;
    ITfSource *pSource = NULL;
    if (_pThreadMgr->QueryInterface(IID_ITfSource, (void **)&pSource) != S_OK)
        return FALSE;
    hr = pSource->AdviseSink(IID_ITfThreadFocusSink, (ITfThreadFocusSink *)this, &_dwThreadFocusSinkCookie);
     pSource->Release();
      return (hr == S_OK);
  }

  // _UninitThreadFocusSink
  // Unadvise a Focus sink.  Assumes a sink has been advised already.
  void
  CTextService::_UninitThreadFocusSink() {
      ITfSource *pSource;
      if (_pThreadMgr->QueryInterface(IID_ITfSource, (void **)&pSource) != S_OK)
          return;
      pSource->UnadviseSink(_dwThreadFocusSinkCookie);
      pSource->Release();
  }

  STDAPI
  CTextService::OnSetThreadFocus() {
	  dbg("CTextService::OnSetThreadFocus\n");
	  gcin_im_client_focus_in(handle);
      return S_OK;
  }

  STDAPI
  CTextService::OnKillThreadFocus()
  {
	  dbg("CTextService::OnKillThreadFocus\n");
	  gcin_im_client_reset(handle);
	  gcin_im_client_focus_out(handle);
      return S_OK;
  }