#include ".\imeui.h"
#include "ChewingIME.h"
#include "IMCLock.h"
#include "IMEUILock.h"

#include "CompStr.h"

#include "CompWnd.h"
#include "CandWnd.h"
#include "StatusWnd.h"
//#include "XPToolbar.h"

#include <windows.h>
#include <multimon.h>
#include <assert.h>

extern bool is_ie;

IMEUI::IMEUI(HWND hUIWnd) : hwnd(hUIWnd)
{
	fixedCompWndPos.x = fixedCompWndPos.y = 0;
}

IMEUI::~IMEUI(void)
{
}

void pr_pos(char *title, INPUTCONTEXT *ic)
{
	POINT &ptca=ic->cfCandForm[0].ptCurrentPos;
	POINT &ptco=ic->cfCompForm.ptCurrentPos;

	dbg("%s comp:%d,%d cand:%d,%d\n", title, ptca.x, ptca.y, ptco.x, ptco.y);
}


LRESULT IMEUI::onIMENotify( HIMC hIMC, WPARAM wp , LPARAM lp )
{
    if ( hIMC==NULL )    {
        return  0;
    }

	IMCLock imc(hIMC);

//	dbg("onIMENotify %d\n", wp);

	switch(wp)
	{
	case IMN_CLOSESTATUSWINDOW:
#if _DEBUG
		dbg("closeStatusWnd\n");
#endif
//		closeStatusWnd();
		break;
	case IMN_OPENSTATUSWINDOW:
#if _DEBUG
		dbg("IMN_OPENSTATUSWINDOW\n");
#endif
//		openStatusWnd(hIMC);
		break;
	case IMN_OPENCANDIDATE:
		{
			if (!imc.getIC())
				break;
#if _DEBUG
			pr_pos("----------------------- IMN_OPENCANDIDATE", imc.getIC());
			dbg("style %d\n", imc.getIC()->cfCandForm[0].dwStyle);
#endif
			CompStr* cs = imc.getCompStr();
			CANDIDATEFORM &fo = imc.getIC()->cfCandForm[0];
			POINT &ptca= fo.ptCurrentPos;

			if (fo.dwStyle==CFS_EXCLUDE) {
//				dbg("bot %d %d\n", imc.getIC()->cfCandForm[0].rcArea.bottom, imc.getIC()->cfCandForm[0].rcArea.top);
				dbg("Exculde a\n");
				ptca.y = fo.rcArea.bottom;

				POINT pt;
				if (GetCaretPos(&pt)) {
					dbg("caret pt %d,%d\n", pt.x, pt.y);

					if (pt.x > ptca.x)
						ptca.x = pt.x;
					dbg("pctax %d\n", ptca.x);
				}
			} else 
			if (fo.dwStyle==CFS_DEFAULT)
			{
#if 1
				dbg("CFS_DEFAULT %d,%d\n", ptca.x, ptca.y);
				IMEUILock lock( hwnd );
				IMEUI* ui = lock.getIMEUI();
				if( ! ui )
					break;

				ui->compWnd.getCandPos(imc, &ptca);

				if (ptca.x < 3 && ptca.y < 3) {
					if (GetCaretPos(&ptca))
						ptca.y+=18;
					dbg("caret pt %d,%d\n", ptca.x, ptca.y);
				}
#endif
			} else {
				POINT pt;
				if (GetCaretPos(&pt)) {
					dbg("pt %d,%d\n", pt.x, pt.y);
				}
			}

			dbg("ptca %d %d\n", ptca.x, ptca.y);
#if 0
			if (is_ie)
				ptca.y+=10;
#endif

			gcin_im_client_set_cursor_location(cs->gcin_handle,  ptca.x, ptca.y); // temp solution
		}
//		openCandWnd();
		break;
	case IMN_CHANGECANDIDATE:
		{
			IMCLock imc(hIMC);
#if _DEBUG
		dbg("IMN_CHANGECANDIDATE\n");
		pr_pos("aa IMN_SETCANDIDATEPOS", imc.getIC());
#endif
		}
		break;
	case IMN_CLOSECANDIDATE:
#if _DEBUG
		dbg("IMN_CLOSECANDIDATE\n");
#endif
//		closeCandWnd();
		break;
	case IMN_SETCANDIDATEPOS:
#if 1
		{
			CompStr* cs = imc.getCompStr();
			CANDIDATEFORM &fo = imc.getIC()->cfCandForm[0];
			POINT &ptca= fo.ptCurrentPos;
			DWORD style = fo.dwStyle;
#if _DEBUG
			pr_pos("aa IMN_SETCANDIDATEPOS", imc.getIC());

			dbg("IMN_SETCANDIDATEPOS %d  bottom:%d,%d\n", style, imc.getIC()->cfCompForm.rcArea.bottom, imc.getIC()->cfCompForm.rcArea.top);
			dbg("a yyyy %d,%d\n", imc.getIC()->cfCandForm[0].rcArea.bottom, imc.getIC()->cfCandForm[0].rcArea.top);
#endif

			if (fo.dwStyle==CFS_EXCLUDE) {
				dbg("CFS_EXCLUDE\n");
//				dbg("bot %d %d\n", imc.getIC()->cfCandForm[0].rcArea.bottom, imc.getIC()->cfCandForm[0].rcArea.top);
				ptca.y = fo.rcArea.bottom;
			} 

			if (!cs->comp_started)
				gcin_im_client_set_cursor_location(cs->gcin_handle,  ptca.x, ptca.y); // temp solution
#if 0
			RECT rc;
			IMEUI::getWorkingArea( &rc, imc.getIC()->hWnd);
			POINT ptnew = getCandWndPos(imc);
			dbg("ptnew %d %d\n", ptnew.x, ptnew.y);
			dbg("cccccccccc %d,%d %d,%d\n", rc.left, rc.top, rc.right, rc.bottom);
#endif
		}
#endif
		break;
	case IMN_SETCONVERSIONMODE:
#if _DEBUG
		dbg("IMN_SETCONVERSIONMODE\n");
//		statusWnd.updateIcons(hIMC);
#endif
		break;
	case IMN_SETSENTENCEMODE:
		break;
	case IMN_SETOPENSTATUS:
		break;
	case IMN_SETCOMPOSITIONFONT:
		if ( ! g_isWinLogon )		
		{
#if _DEBUG
			dbg("IMN_SETCOMPOSITIONFONT\n");
#endif
			if(imc.getIC())
				compWnd.setFont( (LOGFONT*)&imc.getIC()->lfFont );
		}
		break;
	case IMN_SETCOMPOSITIONWINDOW:
		if ( ! g_isWinLogon )
		{
	// The IMN_SETCOMPOSITIONWINDOW message is sent when the composition form of 
	// the Input Context is updated. When the UI window receives this message, 
	// the cfCompForm of the Input Context can be referenced to obtain the new 
	// conversion mode.
			POINT pt = getCompWndPos(imc);
			CompStr* cs = imc.getCompStr();
			CANDIDATEFORM &fo = imc.getIC()->cfCandForm[0];
#if _DEBUG
			pr_pos("IMN_SETCOMPOSITIONWINDOW", imc.getIC());
#endif
			if( !compWnd.isWindow() )
				compWnd.create(hwnd);

			DWORD style = fo.dwStyle;
#if _DEBUG
			dbg("%d,%d style:%d  bottom:%d\n", pt.x, pt.y, style, imc.getIC()->cfCompForm.rcArea.bottom);
			dbg("yyyy %d\n", imc.getIC()->cfCandForm[0].rcArea.bottom);
#endif
			POINT &ptca=fo.ptCurrentPos;
#if _DEBUG
			POINT ptcan;
			compWnd.getCandPos(imc, &ptcan);
			dbg("can %d,%d\n", ptcan.x, ptcan.y);
#endif

			if (fo.dwStyle==CFS_EXCLUDE) {
				dbg("Exclude b\n");
//				dbg("bot %d %d\n", imc.getIC()->cfCandForm[0].rcArea.bottom, imc.getIC()->cfCandForm[0].rcArea.top);
				ptca.y = fo.rcArea.bottom;
			}
#if 0
			int ofs=0;
			gcin_im_client_set_cursor_location(cs->gcin_handle,  ptca.x, ptca.y  + ofs); // temp solution
#endif
			compWnd.move(pt.x, pt.y);
		}
		break;
	case IMN_PRIVATE:
		if ( ! g_isWinLogon )
		{
#if _DEBUG
			dbg("IMN_PRIVATE\n");
#endif
			switch( lp )
			{
			case 0:
				showUserNotify(IMCLock( hIMC ));
				break;
			}
		}
	case IMN_GUIDELINE:
	// The IMN_GUIDELINE message is sent when an IME is about to show an error or 
	// information. When the application or UI window receives this message, either 
	// one can call ImmGetGuideLine to obtain information about the guideline.
		break;
	case IMN_SOFTKBDDESTROYED:
		break;
	}
	return 0;
}


LRESULT CALLBACK IMEUI::wndProc( HWND hwnd, UINT msg, WPARAM wp, LPARAM lp )
{
	IMEUILock uilock(hwnd);
	IMEUI* ui = uilock.getIMEUI();
	if( ! ui )
		ui = uilock.createIMEUI();
	if( ui )
		return ui->wndProc( msg, wp, lp );
	return 0;
}

BOOL IMEUI::registerUIClasses()
{
	WNDCLASSEX wc;
	wc.cbSize			= sizeof(WNDCLASSEX);
	wc.style			= CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS| CS_IME;
	wc.lpfnWndProc		= (WNDPROC)IMEUI::wndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 2 * sizeof(LONG);
	wc.hInstance		= g_dllInst;
	wc.hCursor			= LoadCursor( NULL, IDC_ARROW );
	wc.hIcon			= NULL;
	wc.lpszMenuName		= (LPTSTR)NULL;
	wc.lpszClassName	= g_chewingIMEClass;
	wc.hbrBackground	= NULL;
	wc.hIconSm			= NULL;
	if( !RegisterClassEx( (LPWNDCLASSEX)&wc ) 
		|| !CompWnd::registerClass()
		|| !CandWnd::registerClass()
//		|| !StatusWnd::registerClass()
//		|| !Tooltip::registerClass() 
	)
		return FALSE;
	return TRUE;
}

extern bool sys_end_session;
LRESULT IMEUI::wndProc( UINT msg, WPARAM wp, LPARAM lp)
{
	HIMC hIMC = (HIMC)GetWindowLong(hwnd, IMMGWL_IMC);

	switch(msg)
	{
	case WM_IME_NOTIFY:
		if( ! hIMC )
			return 0;
#if _DEBUG
		dbg("WM_IME_NOTIFY\n");
#endif
		onIMENotify( hIMC,wp, lp );
		break;
	case WM_IME_STARTCOMPOSITION:
		{
#if _DEBUG
			dbg("WM_IME_STARTCOMPOSITION\n");
#endif
			if( ! hIMC )
				return 0;

			if( !compWnd.isWindow() )
				compWnd.create(hwnd);
			// Can not lock imc in winlogon
			if( ! g_isWinLogon ) {
				IMCLock imc( hIMC );
				if( !imc.getIC() )
					break;
				POINT &p=imc.getIC()->cfCompForm.ptCurrentPos;
#if _DEBUG
				dbg("WM_IME_STARTCOMPOSITION %d,%d\n", p.x, p.y);
#endif
				POINT pt = getCompWndPos( imc );			
				compWnd.move(pt.x, pt.y);
			} else {
				compWnd.move(0, 0);
			}
			break;
		}
	case WM_IME_COMPOSITION:
#if _DEBUG
		dbg("WM_IME_COMPOSITION\n");
#endif
		if( ! hIMC )
			return 0;
		return onComposition( hIMC, wp, lp );
	case WM_IME_ENDCOMPOSITION:
		{
#if _DEBUG
			dbg("WM_IME_ENDCOMPOSITION\n");
#endif
			compWnd.hide();
			break;
		}
	case WM_IME_SETCONTEXT:
		{
#if _DEBUG
			dbg("WM_IME_SETCONTEXT\n");
#endif
			if( wp )
			{
				if( hIMC )
				{
					if( (lp & ISC_SHOWUICOMPOSITIONWINDOW)
					&& ! compWnd.getDisplayedCompStr().empty() )
						compWnd.show();
//					statusWnd.show();
				}
				else
				{
					compWnd.hide();
//					statusWnd.hide();
				}
			}
			else
			{
				compWnd.hide();
//				statusWnd.hide();
			}
			break;
		}
	case WM_IME_RELOADCONFIG:
#if _DEBUG
		dbg("WM_IME_RELOADCONFIG\n");
#endif
#if 0
		if( g_hideStatusWnd && statusWnd.isVisible() )
			statusWnd.hide();
#endif
		break;
	case WM_CREATE:
		{
//			dbg("WM_CREATE\n");
			break;
		}
	case WM_NCDESTROY:
		{
#if _DEBUG
			dbg("WM_NCDESTROY\n");
#endif
			HGLOBAL hIMEUI = (HGLOBAL)GetWindowLong(hwnd, IMMGWL_PRIVATE);
			IMEUI* ui = (IMEUI*)GlobalLock(hIMEUI);
			if(ui)
				ui->~IMEUI();	// delete ui
			GlobalUnlock(hIMEUI);
			GlobalFree(hIMEUI);
		}
		break;
#if 1
	case WM_QUERYENDSESSION:
//		dbg("WM_QUERYENDSESSION\n");
		sys_end_session = true;
		return 1;
	case WM_ENDSESSION:
		sys_end_session = true;
//		dbg("WM_ENDSESSION\n");
#endif
	default:
		if( !IsImeMessage(msg) )
			return DefWindowProc(hwnd, msg, wp, lp);
	}
	return 0;
}


void IMEUI::closeStatusWnd(void)
{
#if 0
//	char log[100];
//	sprintf(log, "CLOSE: hwnd=%x, himc=%x", hwnd, hIMC );
	if( statusWnd.isWindow() )
		statusWnd.hide();
#endif
}

void IMEUI::openStatusWnd(HIMC hIMC)
{
#if 0
	if( g_hideStatusWnd )
		return;

	if( !statusWnd.isWindow() )
		statusWnd.create(hwnd);

	if ( g_isWinLogon )
		return;

	IMCLock imc(hIMC);
	INPUTCONTEXT* ic = imc.getIC();

	if( ic )
	{
		if( ic->ptStatusWndPos.x == -1 && ic->ptStatusWndPos.y == -1 )
		{
			RECT rc;
			IMEUI::getWorkingArea( &rc, ic->hWnd );
			int w, h;
			statusWnd.getSize(&w, &h);
			ic->ptStatusWndPos.x = rc.right - w;
			ic->ptStatusWndPos.y = rc.bottom - h - 32;
		}
		statusWnd.move( ic->ptStatusWndPos.x, ic->ptStatusWndPos.y );
	}
	statusWnd.show();
#endif
}

void IMEUI::openCandWnd(void)
{
#if 0
	if( !candWnd.isWindow() )
		candWnd.create(hwnd);

	showCandWnd();
#endif
}


void IMEUI::closeCandWnd(void)
{
#if 0
	candWnd.destroy();
#endif
}

bool IMEUI::getWorkingArea(RECT* rc, HWND app_wnd)
{
	HMONITOR mon = MonitorFromWindow( app_wnd, MONITOR_DEFAULTTONEAREST);
	MONITORINFO mi;
	mi.cbSize = sizeof(mi);
	if( GetMonitorInfo(mon, &mi) )
		*rc = mi.rcWork;
	return true;
}

void IMEUI::unregisterUIClasses()
{
	UnregisterClass(g_chewingIMEClass, g_dllInst);
	UnregisterClass(g_candWndClass, g_dllInst);
	UnregisterClass(g_compWndClass, g_dllInst);
	UnregisterClass(g_statusWndClass, g_dllInst);
//	Tooltip::unregisterClass();
//	XPToolbar::unregisterClass();
}

LRESULT IMEUI::onComposition(HIMC hIMC, WPARAM wp , LPARAM lp)
{
	if ( g_isWinLogon )
		return 0;
	IMCLock imc(hIMC);
	if( !imc.getIC() )
		return 0;
#if _DEBUG
	dbg("onComposition\n");
#endif
	CompStr* cs = imc.getCompStr();

	if( !compWnd.isWindow() )
		compWnd.create(hwnd);

	if( lp & GCS_COMPSTR )
	{
		compWnd.refresh();
		POINT pt = getCompWndPos(imc);
		compWnd.move( pt.x, pt.y );
		int w, h;
		compWnd.getSize(&w, &h);
		SetWindowPos( compWnd.getHwnd(), NULL, 0, 0, w, h, SWP_NOACTIVATE|SWP_NOZORDER|SWP_NOMOVE );

		if( *cs->getCompStr() )
		{
			if( !compWnd.isVisible() )
				compWnd.show();
		}
		else
			compWnd.hide();

	}
	if( (lp & GCS_COMPSTR) || (lp & GCS_CURSORPOS) )
		if( compWnd.isVisible() )
			compWnd.refresh();
	return LRESULT(0);
}

POINT IMEUI::getCompWndPos(IMCLock& imc)
{
	POINT pt;
#if 1
	{
		pt = imc.getIC()->cfCompForm.ptCurrentPos;
		dbg("getCompWndPos %d,%d\n", pt.x, pt.y);
		bool absolute = false;
#if 0
		if( g_fixCompWnd || 0 == imc.getIC()->cfCompForm.dwStyle )
		{
			RECT rc;
			if( g_fixCompWnd || !GetCaretPos( &pt ) )
			{
				getWorkingArea( &rc, imc.getIC()->hWnd );
				pt.x = rc.left + 10;
				pt.y = rc.bottom -= 50;
				absolute = true;
			}
		}
#endif
		imc.getIC()->cfCompForm.ptCurrentPos = pt;
		if( ! (imc.getIC()->fdwInit & INIT_COMPFORM) )
			imc.getIC()->fdwInit |= INIT_COMPFORM;
		if( !absolute )
			ClientToScreen( imc.getIC()->hWnd, &pt );
	}
#else
	pt.x=pt.y=0;
#endif
	return pt;
}


POINT IMEUI::getCandWndPos(IMCLock& imc)
{
	POINT pt;
	pt.x = pt.y = 0;
	return pt;
}


void IMEUI::showCandWnd(void)
{
#if 0
	if( ! candWnd.isWindow() )
		candWnd.create(hwnd);

	candWnd.updateSize();

	if ( g_isWinLogon )
		return;

	POINT pt = getCandWndPos( IMCLock(getIMC()) );
#if _DEBUG
	dbg("showCandWnd %d %d\n", pt.x, pt.y);
#endif
	candWnd.move( pt.x, pt.y );

	if( candWnd.isVisible() )
		candWnd.refresh();
	else
		candWnd.show();
#endif
}

void IMEUI::showUserNotify(IMCLock& imc)
{
	CompStr* cs = imc.getCompStr();
	LPCWSTR msg = cs->getShowMsg();
	if( *msg )
	{
//		POINT pt = getCompWndPos(imc);
//		tooltip.showTip(pt.x, pt.y + 22, msg, 1500);
		POINT pt = getCandWndPos(imc);
//		tooltip.showTip(pt.x, pt.y, msg, 1500);
	}
#if 0
	else if(tooltip.isVisible())
		tooltip.hideTip();
#endif
}


