// ChewingClient.cpp: implementation of the ChewingClient class.
//
//////////////////////////////////////////////////////////////////////

#include "ChewingClient.h"
#include <string.h>
#include <tchar.h>
#include ".\chewingclient.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ChewingClient::ChewingClient( int kbLayout, bool spaceAsSel, const char* selKeys, bool AdvAfterSel, bool EscCleanAllBuf )
	: serverWnd(NULL), chewingID(0), sharedMem(INVALID_HANDLE_VALUE)
	, spaceAsSelection(spaceAsSel)
	, keyLayout(kbLayout)
    , advAfterSelection(AdvAfterSel)
	, escCleanAllBuf( EscCleanAllBuf )
{
}

ChewingClient::~ChewingClient()
{
//	SendMessage( serverWnd, ChewingServer::cmdRemoveClient, 0, chewingID );
    if ( sharedMem==INVALID_HANDLE_VALUE )
    {
        CloseHandle(sharedMem);
    }
}

void ChewingClient::SetKeyboardLayout(int kb)
{	/*SendMessage( serverWnd, ChewingServer::cmdSetKeyboardLayout, kb, chewingID);	*/}

void ChewingClient::SetHsuSelectionKeyType(int type)
{	/* SendMessage( serverWnd, ChewingServer::cmdSetHsuSelectionKeyType, type, chewingID);	*/}

int ChewingClient::Esc()
{	/* return (int)SendMessage( serverWnd, ChewingServer::cmdEsc, 0, chewingID);*/	return 0;}

int ChewingClient::Enter()
{	/* return (int)SendMessage( serverWnd, ChewingServer::cmdEnter, 0, chewingID); */	return 0;}

int ChewingClient::Capslock()
{/*	return (int)SendMessage( serverWnd, ChewingServer::cmdCapslock, 0, chewingID);	*/ return 0;}

// Return the i-th selection key, i >= 0.
char ChewingClient::SelKey(int i)
{/*	return (char)SendMessage( serverWnd, ChewingServer::cmdGetSelKey, i, chewingID);	*/ return 0;}

void ChewingClient::SetAdvanceAfterSelection(bool bDo)
{
}

void ChewingClient::SelKey(char* selkey)
{
}

char* ChewingClient::ZuinStr()
{/*
	int len = (int)SendMessage( serverWnd, ChewingServer::cmdZuinStr, 0, chewingID);
	return (char*)GetDataFromSharedMem(len);*/ return NULL;
}

char* ChewingClient::CommitStr()
{
	return NULL;
}

int   ChewingClient::CommitReady()
{	/*return (int)SendMessage( serverWnd, ChewingServer::cmdCommitReady, 0, chewingID);*/	return 0;}

char* ChewingClient::Buffer()
{/*
	int len = (int)SendMessage( serverWnd, ChewingServer::cmdBuffer, 0, chewingID);
	return (char*)GetDataFromSharedMem(len);*/ return NULL;
}

int   ChewingClient::BufferLen()
{	return 0;}

int ChewingClient::CursorPos()
{	/*return (int)SendMessage( serverWnd, ChewingServer::cmdCursorPos, 0, chewingID);*/	return 0;}

int ChewingClient::ChineseMode()
{	/* return (int)SendMessage( serverWnd, ChewingServer::cmdChineseMode, 0, chewingID);*/	return 0;}

// CandidateWindow-related routines
int ChewingClient::Candidate()
{	/*return (int)SendMessage( serverWnd, ChewingServer::cmdCandidate, 0, chewingID);*/	return 0;}

char* _gen_event_name(char *buf, int szbuf, const char *prefix)
{
	char temp[512]={'0'};
	DWORD sztemp = sizeof(temp);
	GetUserName(temp, &sztemp);

	strncpy(buf, prefix, szbuf);
	strncat(buf, "_", szbuf);
	strncat(buf, temp, szbuf);
	buf[szbuf-1] = '\0';
	return	buf;
}

void ChewingClient::ConnectServer(void)
{
#if 0
	char tempname[512];
//	_gen_event_name(tempname, sizeof(tempname), chewingServerClassName);
	serverWnd = FindWindow( tempname, NULL );
	if( ! serverWnd )
	{
		char evt_name[512];
		_gen_event_name(evt_name, sizeof(evt_name), "Local\\ChewingServerEvent");
		LPCTSTR evtname = evt_name;

		DWORD osVersion = GetVersion();
 		DWORD major = (DWORD)(LOBYTE(LOWORD(osVersion)));
		DWORD minor =  (DWORD)(HIBYTE(LOWORD(osVersion)));
		if( osVersion >= 0x80000000 || major <= 4 )	// Windows 9x or Windows NT 4
			evtname += 6;	// remove prfix "Local\\"

		HANDLE evt = CreateEvent( NULL, TRUE, FALSE, evtname );
		TCHAR server_path[MAX_PATH];
		GetSystemDirectory( server_path, MAX_PATH );
		_tcscat( server_path, _T("\\IME\\Chewing\\ChewingServer.exe") );
		ShellExecute( NULL, "open", server_path, NULL, NULL, SW_HIDE );
		WaitForSingleObject( evt, 10000 );
		CloseHandle(evt);
		serverWnd = FindWindow( tempname, NULL );
	}

//	chewingID = SendMessage( serverWnd, ChewingServer::cmdAddClient, 0, 0 );
	GetWindowText( serverWnd, tempname, sizeof(tempname) );
	_gen_event_name(filemapName, sizeof(filemapName), tempname);

	SetSpaceAsSelection(spaceAsSelection);
	SetKeyboardLayout(keyLayout);
#endif
}


bool ChewingClient::CheckServer()
{
	return true;
}

void ChewingClient::ReloadSymbolTable(void)
{
//	SendMessage( serverWnd, ChewingServer::cmdReloadSymbolTable, 0, 0);
}