#!/bin/bash
# Steven Shiau <steven _at_ nchc org tw>
# License: GPL
# Des: download the syslinux and extract the necessary program for DRBL.
# The reason we do not use syslinux rpm/deb is that it's not easy to make
# all distribution works, otherwise you have to use the statically link program.
# I am lazy... do not want to compile it everytime.
# Note: from syslinux 3.30-pre5, we add vesamenu.c32 here.
DRBL_NEED="isolinux.bin memdisk menu.c32 vesamenu.c32 pxelinux.0 chain.c32 mboot.c32 README.menu mbr.bin syslinux.exe"
SYSLINUX_URL="http://www.kernel.org/pub/linux/utils/boot/syslinux/"

usage() {
  echo "Usage: $0 VERSION [BRANCH]"
  echo "Ex: $0 3.11-pre3 Testing"
}

ver="$1"
branch="$2"
case "$branch" in
  "testing"|"Testing"|"test")
     branch_path="Testing"
     ;;
  *)
     #stable, released one
     branch_path="./"
     ;;
esac

[ -z "$ver" ] && usage && exit 1
tarball=syslinux-${ver}.tar.gz
tmp_wd=`mktemp -d /tmp/syslinux.XXXXXXX`
[ ! -d "syslinux" ] && mkdir -p syslinux
wd=`pwd`
cd $tmp_wd 
wget $SYSLINUX_URL/$branch_path/$tarball
tar xzf $tarball
for iprog in $DRBL_NEED; do
  find ./ -name "$iprog" -type f -exec cp -afv {} $wd/syslinux/ \;
done
# change the mode, no idea why main.c32 and chain.c32 is 755
find $wd/syslinux/ -type f -exec chmod 644 {} \;
echo $ver > $wd/syslinux/VERSION
[ -d "$tmp_wd" ] && rm -rf $tmp_wd
