#!/bin/bash
# Author: Steven Shiau <steven _at_ nchc org tw>
# License: GPL

. /opt/drbl/sbin/drbl-conf-functions

# Settings
# try IP from 192.168."100".254
private_IP_alias_eth_def="100"

# functions
USAGE() {
    echo "To start, restart or stop DRBL service in DRBL Live environment."
    echo "Usage:"
    echo "$0 {start|stop|restart}"
    echo "start   Start DRBL services now"
    echo "stop    Stop DRBL services now"
    echo "restart Restart DRBL services now"
    echo "Example: To start all DRBL services in this DRBL Live server"
    echo "$0 start"
}

# set locale for clients
set_locale_for_clients() {
  # Some of the code is referred to pakcage casper /usr/share/initramfs-tools/scripts/casper-bottom/14locales
  # We use the locale from server as the default one in client.
  if [ -e /etc/default/locale ]; then
      grep_file=/etc/default/locale
  elif [ -e /etc/environment ]; then # Old locales policy
      grep_file=/etc/environment
  fi
  if [ -n "${grep_file}" ]; then
      # use server's configured locale
      locale=$(grep -s 'LANG=' ${grep_file} | sed s/'LANG='// | tr -d '"' )
  fi
  if [ -z "$locale" ]; then
      # Set a default one
      locale=en_US.UTF-8
  fi
  LANG="${locale}"

  # write the setting in clients.
  for ih in $drblroot/*; do
    echo "LANG=${LANG}" > $ih/${grep_file}
  done
  echo "Since some config files are modified in template client, recreating template tarball for DRBL SSI..."
  gen_ssi_files
} # end of set_locale_for_clients
#
config_network(){
  eth_port_no="$(get-nic-devs | wc -l)"
  configured_ip_no="$(get-all-nic-ip -i | wc -w)"
  while [ "$configured_ip_no" -lt "$eth_port_no" ]; do
    ocs-live-netcfg
    configured_ip_no="$(get-all-nic-ip -i | wc -w)"
    [ "$configured_ip_no" -eq "$eth_port_no" ] && break
    [ "$BOOTUP" = "color" ] && $SETCOLOR_WARNING
    echo "Note! You have more than one network cards. Now you can continue to configure them if you want. However, remember those network cards for clients to connect should NOT be assigned with default gateway!"
    [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
    echo "Continue to configure another network card ?"
    echo -n "[Y/n] "
    read continue_conf_eth
    case "$continue_conf_eth" in
       n|N|[nN][oO]) break ;;
    esac
  done

  IP_no="$(get-all-nic-ip -i | wc -w)"
  if [ "$IP_no" -eq 0 ]; then
    [ "$BOOTUP" = "color" ] && $SETCOLOR_FAILURE
    echo "No IP address is configured!"
    echo "$msg_program_stop"
    [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
    exit 1
  elif [ "$IP_no" -eq 1 ]; then
    [ "$BOOTUP" = "color" ] && $SETCOLOR_WARNING
    echo "Only one IP address, so now creating an alias IP address to be used for DRBL clients..."
    [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
    alias_done="no"
    i="$private_IP_alias_eth_def"
    while [ "$alias_done" = "no" ]; do
      if ! ping -c 3 192.168.$i.254 &>/dev/null; then
        ifconfig eth0:1 192.168.$i.254 netmask 255.255.255.0
        alias_done="yes"
      else
        i=$((i+1))
      fi
    done
    if ! egrep -e "^auto[[:space:]]+eth0:1" /etc/network/interfaces; then
      cat <<-NET_END >> /etc/network/interfaces
auto eth0:1
iface eth0:1 inet static
	address 192.168.$i.254
	netmask 255.255.255.0
NET_END
    fi

  else
    # More than one IP address, so it's not necessary to use alias IP address.
    [ "$BOOTUP" = "color" ] && $SETCOLOR_WARNING
    echo "There is more than one IP addresses. Those not connected to WAN will be used for DRBL clients."
    [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
  fi

}

check_if_root

#
ask_and_load_lang_set en
#
if [ $# -ne 1 ]; then
  USAGE
  exit 1
fi

switch=$1

case "$switch" in
   "start"|"restart")
     # config network first:
     config_network

     #
     echo "$msg_delimiter_star_line"
     echo "Now we will continue to run drblpush to fit the changes."
     echo $msg_this_might_take_several_minutes
     echo -n $msg_press_enter_to_continue
     read
     # run drblpush again so that the network interface can be updated. Maybe there is new ethx.
     # load $client_no_per_NIC
     . /opt/drbl/setup/files/ocs/live-hook/ocs-live.conf
     yes "" | drblpush -i -r 1 -z 1 -p $client_no_per_NIC
     # turn on tcpwrapper
     echo "Setting /etc/hosts.allow..."
     mv -f /etc/hosts.allow /etc/hosts.allow.orig
     client_IP_list="$(get-client-ip-list)"
     client_IP_list="$(echo $client_IP_list)"   # convert to 1 line
     client_IP_list_ar=( $client_IP_list )  # put it in an array
     # We can not list too long in hosts.allow, so put 20 elements in a line.
     nloop="$(echo "scale=0; ${#client_IP_list_ar[@]}/20" | bc -l )"
     echo "# Created by drbl-live.sh" > /etc/hosts.allow
     for i in `seq 1 $nloop`; do
       istart="$(echo "scale=0; 20*$((i-1))" | bc -l)"
       iend="$(echo "scale=0; 20*$((i-1))+19" | bc -l)"
       echo -n "ALL: " >> /etc/hosts.allow
       for j in `seq $istart $iend`; do
         echo -n "${client_IP_list_ar[j]} " >> /etc/hosts.allow
       done
       echo >> /etc/hosts.allow
     done

     # set locales for clients.
     set_locale_for_clients
     ;;
   "stop")
     # block all the clients.
     mv -f /etc/hosts.allow /etc/hosts.allow.orig2
     echo "Disabled by drbl-live.sh" > /etc/hosts.allow

     # stop and remove all services
     echo "Stop DRBL service.."
     drbl-all-service stop
     echo "Removing DRBL-related services..."
     drbl-all-service del
     ;;
esac
