/*
 * Author: Blake Huang <klhaung _at_ gmail com>
 * License: GPL
 */
#include <sys/stat.h>
#include <stdio.h>
#include <zlib.h>
#include <bzlib.h>
#include <string.h>
#include <stdlib.h>
#include "mcast.h"

#define BYPASS 0
#define GZ  1
#define BZ2 2

int main(int argc, char *argv[])
{
  char buf[BUFSIZ];
  int len, err, mode, i, n, finished;
  gzFile gz_in  ;
  BZFILE *bz2_in ;
  long long int nBytesToRead, nBytesRead;

  if(argc<2) { printf("Usage: %s [-z0|-gz|-bz2] image_file_size_1, image_file_size_...\n",argv[0]); exit(0); }
  if(!strcmp(argv[1],"-gz")) mode=GZ;
  else if(!strcmp(argv[1],"-bz2")) mode=BZ2;
  else if(!strcmp(argv[1],"-z0")) mode=BYPASS;
  else { printf("Usage %s [-z0|-gz|-bz2] image_file_size_1, image_file_size_...\n",argv[0]); exit(0); }

  finished=0;
  switch(mode) {
    case GZ:     gz_in = gzdopen(0, "rb"); break;
	case BZ2:    bz2_in = BZ2_bzdopen(0, "rb"); break;
  }
  
  for (i=2;i<argc;i++) {
     nBytesToRead = atoll(argv[i]);
     nBytesRead = 0;
     if(i>2) {
       /* skip CVolumeHeader */
       unsigned char vh[512];
       while(nBytesRead!=sizeof(vh)) {
	     switch(mode) {
           case GZ:     len = gzread(gz_in, vh, sizeof(vh)-nBytesRead); break;
		   case BZ2:    len = BZ2_bzread(bz2_in, vh, sizeof(vh)-nBytesRead); break;
		   case BYPASS: len = read(0, vh, sizeof(vh)-nBytesRead); break;
		 }
         if(len<=0) { logit("%d : skip CVolumeHeader failed",i); finished=1; break; }
         nBytesRead += len;
       } 
     }
     if(finished) break;
     logit("%d : nBytesToRead = %d, nBytesRead = %d",i,nBytesToRead,nBytesRead);

     while( (nBytesToRead - nBytesRead) != 0 ) {
       n = sizeof(buf);
       if( (nBytesToRead - nBytesRead) < n ) n = nBytesToRead - nBytesRead;
	   switch(mode) {
         case GZ:     len = gzread(gz_in, buf, n); break;
		 case BZ2:    len = BZ2_bzread(bz2_in, buf, n); break;
		 case BYPASS: len = read(0, buf, n); break;
	   }
       //if (len < 0) { logit("%s : %s", argv[0], gzerror(gz_in, &err)); finished=1; break; }
       if (len == 0) { finished=1; break; }
       if(full_write(1, buf, len)!=len)
       //if ((int)fwrite(buf, 1, (unsigned)len, stdout) != len) 
         logit("%s : failed write %d",argv[0],i);
       nBytesRead += len;
     } //end while
     if(finished) break;
   } //end for

   switch(mode) {
     case GZ:   if (gzclose(gz_in) != Z_OK) logit("%s : failed gzclose",argv[0]); break;
	 case BZ2:  BZ2_bzclose(bz2_in); break;
   }

  logit("%s : done...",argv[0]);
  return 0;
}
