/* Copyright (C) 2004, 2005, 2006, 2007, 2008 Bart Hakvoort
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
#ifndef DEFINE_FILESYSTEM
#define DEFINE_FILESYSTEM

#include "../include/Operation.h"

#include <fstream>
#include <sys/stat.h>

namespace GParted
{

class FileSystem
{
public:
	FileSystem() ;
	virtual ~FileSystem() {}

	virtual FS get_filesystem_support() = 0 ;
	virtual void set_used_sectors( Partition & partition ) = 0 ;
	virtual void read_label( Partition & partition ) = 0 ;
	virtual bool write_label( const Partition & partition, OperationDetail & operationdetail ) = 0 ;
	virtual bool create( const Partition & new_partition, OperationDetail & operationdetail ) = 0 ;
	virtual bool resize( const Partition & partition_new,
			     OperationDetail & operationdetail,
			     bool fill_partition = false ) = 0 ;
	virtual bool copy( const Glib::ustring & src_part_path,
			   const Glib::ustring & dest_part_path,
			   OperationDetail & operationdetail ) = 0 ;
	virtual bool check_repair( const Partition & partition, OperationDetail & operationdetail ) = 0 ;
	
protected:
	int execute_command( const Glib::ustring & command, OperationDetail & operationdetail ) ;

	//those are used in several places..
	Glib::ustring output, error ;
	Sector N, S ;
	int exit_status ;
	unsigned int index ;
	
private:

};

} //GParted

#endif //DEFINE_FILESYSTEM
