/************************************************************************/
/* File		dir.h							*/
/*									*/
/* Purpose	This C++ header file defines the File class. The File	*/
/*		class provides a C++ interface to the physical file	*/
/*		routines. These physical file routines include routines	*/
/*		for creating, removing, opening, closing, reading,	*/
/*		writing, and positioning a file.			*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00						*/
/*									*/
/* Date		Thursday, May 2, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef DIR_H				// If not defined...
#define DIR_H				// Then process the header file.

/* Headers	The following headers are required by dir.h.		*/

#include "string++.h"			// String class.
#include "os.h"				// Physical operating system.
#include "utilitymodule.h"		// UtilityModule class.

/* Constant	The following constant defines the default mode that	*/
/*		will be used when a directory is created by the Dir	*/
/*		class member functions.					*/

const int DirMode		= PhysicalOSOwnRWX | PhysicalOSGrpRWX;

/* Constants	These are the Dir class error constants.		*/

const int DirMaxError		= 8;	// Number of error messages.
const int DirNoError		= 0;	// No error.
const int DirPathBuff		= 1;	// Path buffer overflow.
const int DirNoMake		= 2;	// Could not make directory.
const int DirNotDir		= 3;	// Path is not a directory.
const int DirNoHome		= 4;	// Could not get HOME dir.
const int DirNoCWD		= 5;	// Could not get CWD.
const int DirNoChange		= 6;	// Could not change directory.
const int DirNoDel		= 7;	// Could not remove directory.

/* Class	This is the Dir class. The Dir class provides a C++	*/
/*		interface to the physical directory routines. Also, the	*/
/*		Dir class inherits from UtilityModule. UtilityModule	*/
/*		provides common program module functions such as	*/
/*		Report_Error.						*/

class Dir : public UtilityModule
   {
      public:
         Dir();
	 ~Dir();

	 condition Does_Directory_Exist(const char*);
	 condition Does_Directory_Exist(const String&);
	 status Get_Current_Working_Directory(String&);
	 status Change_Directory(const char*);
	 status Change_Directory(const String&);
	 status Create_Directory(const char*,
	    const int = DirMode);
	 status Create_Directory(const String&,
	    const int = DirMode);
	 status Remove_Directory(const char*);
	 status Remove_Directory(const String&);
	 status Get_Home_Directory(String&);
	 status Create_Recursive_Directory(const char*,
	    const int = DirMode);
	 status Create_Recursive_Directory(const String&,
	    const int = DirMode);

      private:
   };

#endif					// DIR_H
