/************************************************************************/
/* File		physicalos.h						*/
/*									*/
/* Purpose	This C++ header file defines the File class. The File	*/
/*		class provides a C++ interface to the physical file	*/
/*		routines. These physical file routines include routines	*/
/*		for creating, removing, opening, closing, reading,	*/
/*		writing, and positioning a file.			*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00						*/
/*									*/
/* Date		Thursday, May 2, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef PHYSICALOS_H			// If not defined...
#define PHYSICALOS_H			// Then process the header file.

/* Headers	The following header is required by physicalos.h.	*/

#include "standards.h"			// Our standards.

/* Constants	These are the constants that are used to create a dir.	*/

const int PhysicalOSOwnRWX	= 0700;	// Owner can read/write/exec.
const int PhysicalOSOwnRead	= 0400;	// Owner can read.
const int PhysicalOSOwnWrite	= 0200;	// Owner can write.
const int PhysicalOSOwnExec	= 0100;	// Owner can execute.
const int PhysicalOSGrpRWX	= 0070;	// Group can read/write/exec.
const int PhysicalOSGrpRead	= 0040;	// Group can read.
const int PhysicalOSGrpWrite	= 0020;	// Group can write.
const int PhysicalOSGrpExec	= 0010;	// Group can execute.
const int PhysicalOSAllRWX	= 0007;	// All can read/write/exec.
const int PhysicalOSAllRead	= 0004;	// All others can read.
const int PhysicalOSAllWrite	= 0002;	// All others can write.
const int PhysicalOSAllExec	= 0001;	// All others can execute.

/* Class	This is the PhysicalOS class. The PhysicalOS class	*/
/*		provides a C++ interface to the physical linux		*/
/*		operatingsystem.					*/

class PhysicalOS
   {
      public:
         PhysicalOS();
	 ~PhysicalOS();

	 int Get_Linux_Umask(void) const;
	 void Set_Linux_Umask(const int);

      private:
   };

#endif					// PHYSICALOS_H
