/************************************************************************/
/* File		dataindexheader.cpp					*/
/*									*/
/* Purpose	This C++ program file contains the class implementation	*/
/*		for the DataIndexHeader class. The DataIndexHeader	*/
/*		class supports the DataIndex class. The DataIndexHeader	*/
/*		class is the ObjectFile user header that is used by the	*/
/*		DataIndex class. The DataIndexHeader class is defined	*/
/*		in the header file dataindex.h.				*/
/*									*/
/* Author	This C++ program file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ program file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00 (Prototype)					*/
/*									*/
/* Date		Sunday, May 26, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#include <string.h>			// C string library.
#include "dataindex.h"			// DataIndex class.

/************************************************************************/
/* Function	DataIndexHeader()					*/
/*									*/
/* Purpose	This is the default ObjectIndexHeader constructor. The	*/
/*		default constructor does nothing.			*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	None.							*/
/************************************************************************/

DataIndexHeader::DataIndexHeader()
   {
   }

/************************************************************************/
/* Function	~DataIndexHeaderRec()					*/
/*									*/
/* Purpose	This is the default ObjectIndexHeader destructor. The	*/
/*		default destructor does nothing.			*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	None.							*/
/************************************************************************/

DataIndexHeader::~DataIndexHeader()
   {
   }

/************************************************************************/
/* Function	void Get_Header_Message(char* message)			*/
/*									*/
/* Purpose	This function can be used to get the contents of the	*/
/*		message area from the DataIndex user header. The	*/
/*		message area is a 64 byte buffer that is written to the	*/
/*		beginning of every single DataIndex file.		*/
/*									*/
/* Input	This function expects the variable 'message' to point	*/
/*		to a 64 byte message buffer.				*/
/*									*/
/* Output	This function will transfer exactly 64 bytes from the	*/
/*		buffer pointed to by the variable 'message' to the	*/
/*		ObjectIndexHeader's message area.			*/
/************************************************************************/

void DataIndexHeader::Get_Header_Message(char* message)
   {
      memcpy(message, itsmessage, 64);
   }

/************************************************************************/
/* Function	void Set_Header_Message(const char* message)		*/
/*									*/
/* Purpose	This function can be used to set the contents of the	*/
/*		message area in the DataIndex user header. The message	*/
/*		area is a 64 byte buffer that is written to the		*/
/*		beginning of every single DataIndex file.		*/
/*									*/
/* Input	This function expects the variable 'message' to point	*/
/*		to a 64 byte message buffer.				*/
/*									*/
/* Output	This function will transfer exactly 64 bytes from the	*/
/*		ObjectIndexHeader's message area to the buffer pointed	*/
/*		to by the variable 'message'.				*/
/************************************************************************/

void DataIndexHeader::Set_Header_Message(const char* message)
   {
      memcpy(itsmessage, message, 64);
   }

/************************************************************************/
/* Function	void Is_Index_Locked(void) const			*/
/*									*/
/* Purpose	This function can be used to determine if the index is	*/
/*		locked. If this function returns TRUE then the index is	*/
/*		locked an operations should not be performed on it.	*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	This function will return the state of the index. If	*/
/*		this function returns TRUE then the index is locked. If	*/
/*		this function returns FALSE then the index is NOT	*/
/*		locked.							*/
/************************************************************************/

condition DataIndexHeader::Is_Index_Locked(void) const
   {
      return(itslockedflag);
   }

/************************************************************************/
/* Function	void Set_Locked_Index_State(const condition indexstate)	*/
/*									*/
/* Purpose	This function can be used to set the state of the index	*/
/*		to a locked or an unlocked state.			*/
/*									*/
/* Input	This function expects the variable 'indexstate' to	*/
/*		contain the new state of the index. If 'indexstate'	*/
/*		contains TRUE then the index is locked. If 'indexstate'	*/
/*		contains FALSE then the index is NOT locked.		*/
/*									*/
/* Output	None.							*/
/************************************************************************/

void DataIndexHeader::Set_Locked_Index_State(const condition indexstate)
   {
      itslockedflag	= indexstate;
   }

/************************************************************************/
/* Function	void Increment_Node_Count(void)				*/
/*									*/
/* Purpose	This function can be used to increment the variable	*/
/*		that contains the number of nodes in the tree.		*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	The private member variable 'itsnodes' will be		*/
/*		incremented by one.					*/
/************************************************************************/

void DataIndexHeader::Increment_Node_Count(void)
   {
      itsnodes++;
   }

/************************************************************************/
/* Function	void Decrement_Node_Count(void)				*/
/*									*/
/* Purpose	This function can be used to decrement the variable	*/
/*		that contains the number of nodes in the tree.		*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	The private member variable 'itsnodes' will be		*/
/*		decremented by one.					*/
/************************************************************************/

void DataIndexHeader::Decrement_Node_Count(void)
   {
      itsnodes--;
   }

/************************************************************************/
/* Function	int Get_Node_Count(void) const				*/
/*									*/
/* Purpose	This function can be used to get the number of nodes	*/
/*		that are in the tree.					*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	This function will return the number of nodes that are	*/
/*		in the tree.						*/
/************************************************************************/

int DataIndexHeader::Get_Node_Count(void) const
   {
      return(itsnodes);
   }

/************************************************************************/
/* Function	void Set_Node_Count(const int nodecount)		*/
/*									*/
/* Purpose	This function can be used to set the number of nodes	*/
/*		that are in the tree.					*/
/*									*/
/* Input	This function expects the variable 'nodecount' to	*/
/*		contain the new value that represents the number of	*/
/*		nodes in the tree.					*/
/*									*/
/* Output	None.							*/
/************************************************************************/

void DataIndexHeader::Set_Node_Count(const int nodecount)
   {
      itsnodes		= nodecount;
   }

/************************************************************************/
/* Function	FilePointer Get_Root_Node(void) const			*/
/*									*/
/* Purpose	This function can be used to get the pointer to the	*/
/*		root node in the red/black tree.			*/
/*									*/
/* Input	None.							*/
/*									*/
/* Output	This function will return a pointer to the root node in	*/
/*		the red/black tree.					*/
/************************************************************************/

FilePointer DataIndexHeader::Get_Root_Node(void) const
   {
      return(itsrootnode);
   }

/************************************************************************/
/* Function	void Set_Root_Node(const FilePointer rootnode)		*/
/*									*/
/* Purpose	This function can be used to set the pointer to the	*/
/*		root node in the red/black tree.			*/
/*									*/
/* Input	This function expects the variable 'rootnode' to	*/
/*		contain the new value for the root node in the		*/
/*		red/black tree.						*/
/*									*/
/* Output	None.							*/
/************************************************************************/

void DataIndexHeader::Set_Root_Node(const FilePointer rootnode)
   {
      itsrootnode	= rootnode;
   }
