/************************************************************************/
/* File		datafile.h						*/
/*									*/
/* Purpose	This C++ header file contains the definition for the	*/
/*		DataFile class. The DataFile class manages a data file	*/
/*		and an index file. The data file contains records of	*/
/*		DataRecord type and the index file indexes the records	*/
/*		in the data file.					*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	00.00.00 (Prototype)					*/
/*									*/
/* Date		Sunday, June 30, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef DATAFILE_H			// If not defined...
#define DATAFILE_H			// Then process the header file.

/* Headers	The following headers are required by datafile.h.	*/

#include "dataindex.h"			// The DataIndex class.
#include "datarecord.h"			// The DataRecord class.

/* Constants	The following constants define the valid DataFile	*/
/*		error codes that are used by the DataFile member	*/
/*		functions.						*/

const int DataFileErrors	= 20;	// Max error messages.
const int DataFileNoError	= 0;	// No error.
const int DataFileNoPrep	= 1;	// DataFile object not prepared.
const int DataFileIsOpen	= 2;	// DataFile object is open.
const int DataFileIsClosed	= 3;	// DataFile object is closed.
const int DataFileMakeData	= 4;	// Could not create data file.
const int DataFileMakeIndex	= 5;	// Could not create index file.
const int DataFileOpenData	= 6;	// Could not open data file.
const int DataFileOpenIndex	= 7;	// Could not open index file.
const int DataFileCloseData	= 8;	// Could not close data file.
const int DataFileCloseIndex	= 9;	// Could not close index file.
const int DataFileNoKey		= 10;	// No search key.
const int DataFileBadFind	= 11;	// Error searching for record.
const int DataFileBadWrite	= 12;	// Error writing data record.
const int DataFileBadRead	= 13;	// Error reading data record.
const int DataFileBadChange	= 14;	// Error changing index value.
const int DataFileBadAddData	= 15;	// Error adding record to file.
const int DataFileBadAddKey	= 16;	// Error adding key to index.
const int DataFileBadDelData	= 17;	// Error removing record.
const int DataFileBadDelIndex	= 18;	// Error removeing key.
const int DataFileNoFind	= 19;	// Record does not exist.

/* Class	The following class defines the DataFile class. The	*/
/*		DataFile class stores DataRecord objects in a data file	*/
/*		and indexes the records with an index file.		*/

class DataFile : UtilityModule
   {
      public:
         DataFile();
	 DataFile(const String&, const int, const DataElementType*);
	 ~DataFile();

	 int Record_Size(void);
	 status Read_From_File(File&, const int);
	 status Write_To_File(File&, const int);

	 void Prepare_DataFile(const String&, const int,
	    const DataElementType*);
	 void Format_Record(DataRecord&);

	 status Create_Files(const String&);
	 status Open_Files(const String&);
	 status Close_Files(void);
	 status Store_Record(DataRecord&);
	 status Remove_Record(DataRecord&);
	 status Get_Record(DataRecord&);
	 status Get_First_Record(DataRecord&);
	 status Get_Next_Record(DataRecord&);
	 status Get_Last_Record(DataRecord&);
	 status Get_Previous_Record(DataRecord&);

      private:
         condition		itscanopenflag;
	 condition		itsisopenflag;
	 String			itsdatafilename;
	 ObjectFile<DataRecord>	itsdatafile;
	 DataIndex		itsindexfile;
	 DataRecord		itsdatarecord;
   };

#endif					// DATAFILE_H
