/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _webbase_h
#define _webbase_h

#include <hash.h>
#include <webbase_url.h>
#include <mysql.h>
#include <uri.h>

#ifdef __cplusplus
extern "C" {
#endif

#define WEBBASE_NAME_LENGTH 		128
#define WEBBASE_PATH_LENGTH 		1024
#define WEBBASE_HOST_LENGTH 		256
#define WEBBASE_MESSAGE_LENGTH 		2048

#define WEBBASE_NOTFOUND		-2

#define WEBBASE_OPTIONS		0x0004000

typedef struct webbase {
  /* Public */
  hash_t* options;
  char name[WEBBASE_NAME_LENGTH + 1];
  char path[WEBBASE_PATH_LENGTH + 1];
  char mysql_host[WEBBASE_HOST_LENGTH + 1];
  unsigned int mysql_port;
  char* mysql_unix_port;
  char* dir;
  int pid;
  int lock_wait;
  int lock_max_loop;

  hash_t* query;

  webbase_url_start_t default_start;

  /* Private */
  MYSQL mysql;
} webbase_t;

struct option* webbase_options(struct option options[]);
webbase_t* webbase_alloc(int argc, char** argv, struct option options[]);
void webbase_free(webbase_t* params);
int webbase_lock(webbase_t* base, int varint, char* varchar);
void webbase_unlock(webbase_t* base, int varint, char* varchar);
void webbase_lock_ignore(webbase_t* base, int varint, char* varchar);

/* 
 * start
 */
#define WEBBASE_START_FIELDS "rowid,url,url_md5,info+0,url_max_size,size_limit,min,depth,level,timeout,loaded_delay,modified_delay,not_found_delay,timeout_delay,robot_delay,auth,accept,filter,allow,disallow,hook_info,count,delay"
#define WEBBASE_START_FIELDS_INSERT "rowid,url,url_md5,info,url_max_size,size_limit,min,depth,level,timeout,loaded_delay,modified_delay,not_found_delay,timeout_delay,robot_delay,delay,auth,accept,filter,allow,disallow,hook_info,count"

typedef void (*webbase_walk_start_callback_t)(char* params, webbase_url_start_t* start);
void webbase_walk_start(webbase_t* base, char* where, webbase_walk_start_callback_t func, char* params);

void webbase_start_free(webbase_url_start_t* start);
void webbase_start_reset(webbase_url_start_t* start);
void webbase_default_start(webbase_t* base, webbase_url_start_t* start);
void webbase_update_start(webbase_t* base, webbase_url_start_t* start);
void webbase_start_state(webbase_t* base, webbase_url_start_t* start, int state);
webbase_url_start_t* webbase_get_start(webbase_t* base, unsigned char* url_md5, webbase_url_start_t* start);
webbase_url_start_t* webbase_get_start_rowid(webbase_t* base, int rowid, webbase_url_start_t* start);
webbase_url_start_t* webbase_get_start_of_url(webbase_t* base, webbase_url_t* webbase_url);
void webbase_enable_start(webbase_t* base, unsigned char* url_md5);
void webbase_merge_start(webbase_url_start_t* to, webbase_url_start_t* from);

/*
 * url
 */
#define WEBBASE_URL_FIELDS "rowid,url,url_md5,info+0,code,unix_timestamp(mtime),unix_timestamp(mtime_error),tags,content_type,content_length,md5,complete_rowid,unix_timestamp(crawl),hookid,extract,title,language"
#define WEBBASE_URL_COMPLETE_FIELDS "keywords,description,base_url,relative,absolute,location"

typedef void (*webbase_walk_url_callback_t)(char* params, webbase_url_t* webbase_url);
/*
 * Same flag as webbase_get_url.
 */
void webbase_walk_url(webbase_t* base, char* where, webbase_walk_url_callback_t func, char* params, int flag);

int webbase_insert_url(webbase_t* base, webbase_url_t* webbase_url);
int webbase_visited(webbase_t* base, char* url);
int webbase_exists_url(webbase_t* base, unsigned char* url_md5);
#define WEBBASE_GET_URL_LIGHT	0x01
#define WEBBASE_GET_URL_ALL	0x02
webbase_url_t* webbase_get_url(webbase_t* base, unsigned char* url_md5, webbase_url_t* webbase_url, int flag);
webbase_url_t* webbase_get_url_rowid(webbase_t* base, int rowid, webbase_url_t* webbase_url, int flag);
webbase_url_t* webbase_get_url_1(webbase_t* base, char* quote, char* field, unsigned char* value, int value_length, webbase_url_t* webbase_url, int flag);
/*
 * start2url 
 */
int webbase_insert_start2url(webbase_t* base, int start_rowid, int url_rowid, int level);
int webbase_get_start2url(webbase_t* base, int* start_rowid, int* url_rowid, int* level);
int webbase_counted(webbase_t* base, webbase_url_start_t* start, int rowid);

#ifdef __cplusplus
}
#endif

#endif /* _webbase_h */
