/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _webtools_h
#define _webtools_h

#include <uri.h>
#include <getopttools.h>

#define WEBTOOLS_READER_HTTP_HEADER		0x0001
#define WEBTOOLS_READER_RAW			0x0002
#define WEBTOOLS_READER_HTTP_BODY		WEBTOOLS_READER_RAW

#define WEBTOOLS_READER_OK			0
#define WEBTOOLS_READER_HTTP_HEADER_SHORT	-2
#define WEBTOOLS_READER_UNKNOWN			-3
#define WEBTOOLS_READER_TRUNC			-4

#define WEBTOOLS_MAX_FD		100

#define callback_http_header	callback1
#define callback_http_body	callback2

#define WEBTOOLS_READER_START		0x01
#define WEBTOOLS_READER_CONTINUE	0x02
#define WEBTOOLS_READER_END		0x04

typedef int (*webtools_reader_callback_t)(char* callback_arg, int sd, char* buffer, int size, int flag);

#define WEBTOOLS_OPTIONS	0x0002000

typedef struct webtools_params {
  /* Common */
  hash_t* options;

  char* http_level;
  webtools_reader_callback_t callback1;
  webtools_reader_callback_t callback2;
  char* callback_arg;
  int mode;
  int timeout;
  int size_limit;
  struct webtools_file {
    char* buffer;
    int buffer_size;
    int buffer_length;
  } files[WEBTOOLS_MAX_FD];
} webtools_params_t;

webtools_params_t* webtools_alloc(int argc, char** argv, struct option options[]);
struct option* webtools_options(struct option options[]);
void webtools_free(webtools_params_t* params);
int webtools_open(webtools_params_t* params, char* host, char* port);
int webtools_write(webtools_params_t* params, int sd, char* buffer, int size);
void webtools_close(webtools_params_t* params, int sd);
int webtools_reader(webtools_params_t* params, int sd);

#endif /* _webtools_h */
