/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <stdio.h>
#include <fcntl.h>

#include <logfile.h>
#include <file_exists.h>
#include <file_size.h>

void logfile(char* file)
{
  int fd;
  int mode;

  if(file_exists(file) && file_size(file) < (100 * 1024))
    mode = O_APPEND | O_WRONLY;
  else
    mode = O_TRUNC | O_CREAT | O_WRONLY;
  if((fd = open(file, mode, 0777)) < 0) {
    fprintf(stderr, "could not open %s for writing\n", file);
    perror("");
    exit(0);
  }
  fflush(stderr);
  if(dup2(fd, 2) < 0) {
    fprintf(stderr, "could not dup2\n");
    perror("");
    exit(0);
  }
  close(fd);
}
