%{
/* GNU chef
   Copyright (C) 1998 Free Software Foundation, Inc.

This file is part of GNU Talkfilters

GNU Talkfilters is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Talkfilters is distributed in the hope that it will be amusing,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Talkfilters; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* chef.x - convert English on stdin to Mock Swedish on stdout
 *
 * The WC definition matches any word character, and the NW definition matches
 * any non-word character.  Two start conditions are maintained: INW (in word)
 * and NIW (not in word).  The first rule passes TeX commands without change.
 *
 * HISTORY
 *
 * Apr 26, 1993; John Hagerman: Added ! and ? to the Bork Bork Bork rule.
 * Apr 15, 1992; John Hagerman: Created.
 */

#include <stdio.h>
#include <stdlib.h>

static int i_seen = 0;
%}

WC		[A-Za-z']
NW		[^A-Za-z']

%start		INW NIW

%%

\\[^ \n]+	ECHO;

{NW}		{
		BEGIN NIW;
		i_seen = 0; ECHO;
		}

[.!?]$          {
		BEGIN NIW; i_seen = 0;
                printf("%c\nBork Bork Bork!", yytext[0]);
		}

<NIW>"bork"/{NW} ECHO;
<NIW>"Bork"/{NW} ECHO;

"an"		{ BEGIN INW; printf("un"); }
"An"		{ BEGIN INW; printf("Un"); }
"au"		{ BEGIN INW; printf("oo"); }
"Au"		{ BEGIN INW; printf("Oo"); }
"a"/{WC}	{ BEGIN INW; printf("e"); }
"A"/{WC}	{ BEGIN INW; printf("E"); }
"en"/{NW}	{ BEGIN INW; printf("ee"); }
<INW>"ew"	{ BEGIN INW; printf("oo"); }
<INW>"e"/{NW}	{ BEGIN INW; printf("e-a"); }
<NIW>"e"	{ BEGIN INW; printf("i"); }
<NIW>"E"	{ BEGIN INW; printf("I"); }
<INW>"f"	{ BEGIN INW; printf("ff"); }
<INW>"ir"	{ BEGIN INW; printf("ur"); }
<INW>"i"	{ BEGIN INW; printf(i_seen++ ? "i" : "ee"); }
<INW>"ow"	{ BEGIN INW; printf("oo"); }
<NIW>"o"	{ BEGIN INW; printf("oo"); }
<NIW>"O"	{ BEGIN INW; printf("Oo"); }
<INW>"o"	{ BEGIN INW; printf("u"); }
"the"		{ BEGIN INW; printf("zee"); }
"The"		{ BEGIN INW; printf("Zee"); }
"th"/{NW}	{ BEGIN INW; printf("t"); }
<INW>"tion"	{ BEGIN INW; printf("shun"); }
<INW>"u"	{ BEGIN INW; printf("oo"); }
<INW>"U"	{ BEGIN INW; printf("Oo"); }
"v"		{ BEGIN INW; printf("f"); }
"V"		{ BEGIN INW; printf("F"); }
"w"		{ BEGIN INW; printf("v"); }
"W"		{ BEGIN INW; printf("V"); }
.		{ BEGIN INW; ECHO; }

%%

#define HELP \
"Usage: %s [OPTIONS]\n\n\
Options:\n\
   --help                   display this help and exit\n\
   --version                output version information and exit\n\n\
This program is a filter; it reads data from standard input, processes it,\n\
and writes the results to standard output.\n"

#define VERSION "GNU chef 1.0"

extern int parse_args(int, char **, char *, char *);

int main(int argc, char **argv)
{

   parse_args(argc, argv, HELP, VERSION);
   
   yylex();

   return(EXIT_SUCCESS);
}
