/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 console.h - header for pseudo-console

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef CONSOLE_H
#define CONSOLE_H

enum {
  W_CONSOLE, W_CONSOLE_LBL, W_CONSOLE_TXT,
  W_CONSOLE_N
};

extern GtkWidget* w_console[W_CONSOLE_N];

void console_create(void);
void console_show(void);
void console_hide(void);
void console_clear(void);
void console_print(char* s, int tidx);
void console_print_size(off_t size, int tidx);

void console_print_stdout(char* s);
void console_print_stderr(char* s);
void console_print_spawn(char* s);

#endif /* CONSOLE_H */
