.TH sourceinstall 1 "2005-06-09" "Claudio Fontana"
.SH NAME

.B sourceinstall
\- source packages installer and management tool

.SH SYNOPSIS

.B sourceinstall
.TP
.B sourceinstall
.I ACTION
[ ACTION_ARG... ]
.br
[
.I OPTION
[ OPTION_ARG... ]... ]
[
.I PACKAGE_NAME
]
.TP
.B sourceinstall
[
.I OPTION
[ OPTION_ARG... ]... ]
.I FILENAME

.SH DESCRIPTION
GNU Source Installer (sourceinstall) is a complete source installations management tool.
It can be used to install, remove, update, query and export information about installed source packages.
It also provides package consistency checks, and uninstallation crosschecks using an internal trace of all files pertaining to each source package.
It works best with source packages prepared with the autotools, and which honour the classic targets and environment variables.
For a more complete manual, try:
.I
info sourceinstall

.SH INTERFACE
As you can see in the SYNOPSIS section, sourceinstall can be called in three different ways.
.br
The first way of launching sourceinstall is without any arguments. This causes the Tk graphical interface to be started, and all further operations can be done from there.
.br
The second way of calling the program is the complete command line interface, where a single action must be specified, followed by zero or more options, possibly followed by a final PACKAGE_NAME if the action requires it.
.br
The third way of calling the program is without specifying any actions, and with a required FILENAME. This is for both convenience and backward compatibility, and is a shortcut for the --add action with no custom package name.

.SH ACTIONS

.TP 
.B "-h, --help"
show brief command line help
.TP 
.B "-V, --version"
show program version
.TP
.B "-l, --list"
list existing packages;
if PACKAGE_NAME is specified, it is an ARE regex of packages to display
.TP
.B "-a, --add FILENAME"
add new source package from FILENAME;
the package name will be taken from the top source directory by default,
or from PACKAGE_NAME if specified
.TP
.B "-r, --remove"
remove source package PACKAGE_NAME
.TP
.B "-c, --check"
show and validate package PACKAGE_NAME information
.TP
.B "-v, --update OLD_PACK FILENAME"
remove package OLD_PACKAGE completely, then add FILENAME.
The new package name will be taken from the top source directory by default,
or from PACKAGE_NAME if specified
.TP
.B "-i, --install"
install known package PACKAGE_NAME from the stored source code
.TP
.B "-u, --uninstall"
alias for -r -b
.TP
.B "-d, --description STRING"
associate first line of STRING to PACKAGE_NAME short description,
and the remaining lines to the long description.
If STRING is empty, remove descriptions from the package.
Use your shell quotation characters to supply a STRING containing newlines.
.TP
.B "-n, --rename OLD_NAME"
rename existing package OLD_NAME to PACKAGE_NAME
.TP
.B "-x, --export FORMAT FILENAME"
export package PACKAGE_NAME information to FILENAME.
FORMAT can be xml, txt or lst
.TP
.B "-p, --pack FILENAME"
build binary tarball from the installed package PACKAGE_NAME,
and save it as FILENAME

.SH OPTIONS
.TP
.B "-s, --source"
apply add or remove action to source only
.TP
.B "-b, --binary"
apply add or remove action to installation only
.TP
.B "-S, --no-source"
alias for --binary
.TP
.B "-B, --no-binary"
alias for --source
.TP
.B "-t, --strip"
strip binaries during installation if possible (not recommended)
.TP
.B "-z, --compression FORMAT"
use FORMAT as compression. Can assume values gz, bz2, Z
.TP
.B "-C, --configure STRING"
(re)configure package using STRING. First character of STRING must be a space, and the whole STRING should be quoted from the shell
.TP
.B "-D, --subdir STRING"
use STRING as build subdirectory for the package
.TP
.B "-f, --force"
force execution of the action even when not recommended (Not Implemented Yet)
.TP
.B "-U, --user STRING"
privileged user login to revert to if required [default=root]
.TP
.B "-P, --pass STRING"
privileged user password to revert to if required [default=]
.TP
.B "-q, --quiet"
output only indispensable information on standard output

.SH BUGS
Report bugs to bug-sourceinstall@gnu.org

.SH AUTHOR
Claudio Fontana

.SH HOME PAGE
.I http://www.gnu.org/software/sourceinstall

.SH FILES

.I ~/.sourceinstall/
\- user specific data directory

.I ~/.sourceinstall/sourceinstallrc
\- user preferences

.I ~/.sourceinstall/build
\- temporary build directory

.I ~/.sourceinstall/install-destdir
\- test install destination directory

.I ~/.sourceinstall/packages
\- installed packages directory

.I ~/.sourceinstall/src
\- user source repository directory

.I ~/.sourceinstall/.sourceinstall_lock
\- lock file. Each user should run only one instance of sourceinstall.

