# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gu, const, soundcard, mpd, mpd.musicdisplayer
from i18n import _
import abstract, gtk
import random

class Teacher(abstract.Teacher):
    def __init__(self, exname, app):
        abstract.Teacher.__init__(self, exname, app)
        self.m_question = None
    def new_question(self):
        self.q_status = const.QSTATUS_NEW
        self.m_question = ["c'", "cis'", "d'", "dis'", "e'", "f'", "fis'", "g'", "gis'", "a'", "ais'", "b'"]
        for x in range(100):
            a = random.randint(0, 11)
            b = random.randint(0, 11)
            self.m_question[a], self.m_question[b] = self.m_question[b], self.m_question[a]
    def play_question(self):
        if self.q_status == const.QSTATUS_NO:
            return
        soundcard.play_note(self.get_int('config/preferred_instrument'),
                        4, 0, mpd.notename_to_int(self.m_question[0]),
                        self.get_int('config/preferred_instrument_velocity'))
    def play_last_note(self):
        if self.q_status == const.QSTATUS_NO:
            return
        soundcard.play_note(self.get_int('config/preferred_instrument'),
                        4, 0, mpd.notename_to_int(self.m_question[-1]),
                        self.get_int('config/preferred_instrument_velocity'))
    def play_all_notes(self):
        if self.q_status == const.QSTATUS_NO:
            return
        s = r"\staff{"
        for n in self.m_question:
            s = s + " " + n
        s = s + "}"
        track = mpd.music_to_track(s)
        track.prepend_patch(0, self.get_int('config/preferred_instrument'))
        soundcard.synth.play_track(track)

class Gui(abstract.Gui):
    def __init__(self, teacher, window):
        abstract.Gui.__init__(self, teacher, window, no_notebook=1)
        self.set_usize(400, -1)
        self.config_box.hide()
        self.m_key_bindings = {'new_ak': self.new_question,
                               'play_first_note_ak': self.m_t.play_question,
                               'play_last_note_ak': self.m_t.play_last_note,
                               'play_all_ak': self.m_t.play_all_notes}
        self.g_music_displayer = mpd.musicdisplayer.MusicDisplayer()
        self.g_music_displayer.clear()
        self.g_music_displayer.set_policy(gtk.POLICY_NEVER, gtk.POLICY_NEVER)
        self.practise_box.pack_start(self.g_music_displayer)
        
        gu.bButton(self.action_area, _("New"), self.new_question)
        self.g_play_first_note = gu.bButton(self.action_area, _("Play first note"), lambda f, s=self: s.m_t.play_question())
        self.g_play_first_note.set_sensitive(gtk.FALSE)
        self.g_play_last_note = gu.bButton(self.action_area, _("Play last note"), lambda f, s=self: s.m_t.play_last_note())
        self.g_play_last_note.set_sensitive(gtk.FALSE)
        self.g_play_all = gu.bButton(self.action_area, _("Play all"), lambda f, s=self: s.m_t.play_all_notes())
        self.g_play_all.set_sensitive(gtk.FALSE)
        self.practise_box.show_all()
    def new_question(self, widget=None):
        self.m_t.new_question()
        self.g_play_first_note.set_sensitive(gtk.TRUE)
        self.g_play_last_note.set_sensitive(gtk.TRUE)
        self.g_play_all.set_sensitive(gtk.TRUE)
        self.m_t.play_question()
        s = r"\staff{"
        for n in self.m_t.m_question:
            s =  s + " " + n
        s = s + "}"
        self.g_music_displayer.display(s, 
                                 self.get_int('config/feta_font_size=20'))
    def on_end_practise(self):
        self.g_music_displayer.clear()
        self.g_play_first_note.set_sensitive(gtk.FALSE)
        self.g_play_last_note.set_sensitive(gtk.FALSE)
        self.g_play_all.set_sensitive(gtk.FALSE)
