# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gnome
import abstract, idbyname, const, mpd, gu, statisticsviewer, widgets
from i18n import _
import soundcard, mpd, mpd.musicdisplayer

class Teacher(idbyname.Teacher):
    def __init__(self, exname, app):
        idbyname.Teacher.__init__(self, exname, app, const.USE_HARMONY)
    def play_question(self):
        if self.q_status == const.QSTATUS_NO:
            return
        tracklist = mpd.music_to_tracklist(self.m_P.get_music())
        l, lv, m, mv, h, hv = self.get_instrument_config(3)
        tracklist[0].prepend_patch(0, h)
        t = tracklist[0]
        for x in range(1, len(tracklist)-1):
            tracklist[x].prepend_patch(x, m)
            t.merge_with(tracklist[x])
        tracklist[-1].prepend_patch(len(tracklist)-1, l)
        t.merge_with(tracklist[-1])
        soundcard.synth.play_track(t)

class Gui(abstract.LessonbasedGui):
    def __init__(self, teacher, window):
        abstract.LessonbasedGui.__init__(self, teacher, window)
        self.m_key_bindings = {'new_ak': self.new_question,
                               'repeat_ak': self.m_t.play_question,
                               'guess_answer_ak': self.guess_answer,
                               'show_ak':  self.show_answer}
        ################
        # practise_box #
        ################
        self.g_music_displayer = mpd.musicdisplayer.MusicDisplayer()
        self.g_music_displayer.set_usize(-1, 170)
        self.practise_box.pack_start(self.g_music_displayer)
        
        self.g_flashbar = gu.FlashBar()
        self.g_flashbar.show()
        self.practise_box.pack_start(self.g_flashbar, gtk.FALSE)
        self.practise_box.set_spacing(gnome.uiconsts.PAD)
 
        self.g_entry = gtk.GtkEntry()
        self.practise_box.pack_start(self.g_entry, gtk.FALSE)
        self.g_new = gu.bButton(self.action_area, _("New"), self.new_question)
        self.g_repeat = gu.bButton(self.action_area, _("Repeat"),
                                   lambda _o, self=self: self.m_t.play_question())
        self.g_repeat.set_sensitive(gtk.FALSE)
        self.g_guess_answer = gu.bButton(self.action_area, _("Guess answer"), 
                                         self.guess_answer)
        self.g_guess_answer.set_sensitive(gtk.FALSE)
        self.g_show = gu.bButton(self.action_area, _("Show"), self.show_answer)
        self.g_show.set_sensitive(gtk.FALSE)
        self.practise_box.show_all()
        ##############
        # config_box #
        ##############
        self.g_lessonfile_selector = widgets.SelectLessonfileWidget(
           self.m_t, self.g_win, self.update_gui_after_lessonfile_change)
        self.g_lessonfile_selector.show()
        self.config_box.pack_start(self.g_lessonfile_selector)
        #self.g_instrument_configurator \
        #    = widgets.InstrumentConfigurator(self.m_exname, 3)
        #self.config_box.pack_start(self.g_instrument_configurator, gtk.FALSE)
        #self.g_instrument_configurator.show()

        ###############
        # statistics
        ###############
        self.setup_statisticsviewer(statisticsviewer.StatisticsViewer,
                                   _("Harmonic progression dictation"))

        self.update_gui_after_lessonfile_change()
    def guess_answer(self, widget=None):
        if self.m_t.q_status == const.QSTATUS_NO:
            return
        if self.m_t.q_status == const.QSTATUS_SOLVED:
            if self.m_t.guess_answer(self.g_entry.get_text()):
                self.g_flashbar.flash(_("Correct, but you have already solved this question"))
            else:
                self.g_flashbar.flash(_("Wrong, but you have already solved this question"))
        else:
            if self.m_t.guess_answer(self.g_entry.get_text()):
                self.g_flashbar.flash(_("Correct"))
                self.g_new.set_sensitive(gtk.TRUE)
            else:
                self.g_flashbar.flash(_("Wrong"))
    def show_answer(self, widget=None):
        if self.m_t.q_status != const.QSTATUS_NO:
            self.g_music_displayer.display(self.m_t.m_P.get_music(),
                               self.get_int('config/feta_font_size=20'))
    def new_question(self, widget=None):
        if self.m_t.new_question() == self.m_t.OK:
            self.g_music_displayer.display(self.m_t.m_P.get_music(),
                        self.get_int('config/feta_font_size=20'), mpd.FIRST)
            self.g_repeat.set_sensitive(gtk.TRUE)
            self.g_show.set_sensitive(gtk.TRUE)
            self.g_guess_answer.set_sensitive(gtk.TRUE)
            self.g_new.set_sensitive(
                 not self.get_bool('config/picky_on_new_question'))
            self.m_t.play_question()
    def on_end_practise(self):
        self.g_new.set_sensitive(gtk.TRUE)
        self.g_repeat.set_sensitive(gtk.FALSE)
        self.g_guess_answer.set_sensitive(gtk.FALSE)
        self.g_show.set_sensitive(gtk.FALSE)
        self.g_music_displayer.clear()
        self.m_t.end_practise()
    def update_gui_after_lessonfile_change(self):
        self.g_music_displayer.clear()
        if self.m_t.m_P:
            self.g_new.set_sensitive(gtk.TRUE)
        else:
            self.g_new.set_sensitive(gtk.FALSE)
        self.g_repeat.set_sensitive(gtk.FALSE)
        self.g_guess_answer.set_sensitive(gtk.FALSE)
        self.g_show.set_sensitive(gtk.FALSE)
        self.m_t.m_statistics.lessonfile_changed(
                     self.get_string('lessoncollection'),
                     self.get_string('lessonfile'))
        self.g_statview.m_descriptive_paragraph = \
         _("Statistics for the lesson file '%s'") % self.get_string('lessonfile')
        self.g_win.set_title("Solfege - " + self.get_pretty_name())
