"======================================================================
|
|   Smalltalk TCP/IP sockets - Datagram class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Object subclass: #Datagram
	  instanceVariableNames: 'data address port'
	  classVariableNames: ''
	  poolDictionaries: ''
	  category: 'Sockets-Protocols'
!


!Datagram class methodsFor: 'instance creation'!

data: aByteArray address: ipAddress port: port
    ^self new setData: aByteArray address: ipAddress port: port
!

object: object address: ipAddress port: port
    | stream |
    stream := ByteStream on: (ByteArray new: 100).
    ^self
        data: (ObjectDumper dump: object to: stream)
        address: ipAddress
        port: port
! !

!Datagram methodsFor: 'accessing'!

address
    ^address
!

address: ipAddress
    address := ipAddress
!

data
    ^data
!

data: aByteArray
    data := aByteArray
!

get
    ^ObjectDumper loadFrom: (ByteStream on: self data)
!

port
    ^port
!

port: thePort
    port := thePort
! !

!Datagram methodsFor: 'private'!

setData: aByteArray address: ipAddress port: thePort
    data := aByteArray.
    address := ipAddress.
    port := thePort
!

sockaddr
    ^address port: port
! !
