"======================================================================
|
|   AbstractSocketImpl
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

UnixStream subclass: #AbstractSocketImpl
	   instanceVariableNames: 'localAddress localPort remoteAddress remotePort'
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!AbstractSocketImpl class methodsFor: 'constants'!

soLinger         ^128!
soReuseAddr      ^4!
soTimeout        ^16r1006!
tcpNoDelay       ^1!

sockDgram       ^2!
sockStream      ^1!
!

!AbstractSocketImpl methodsFor: 'abstract'!

available
    self subclassResponsibility
!

bindTo: ipAddress port: port
    self subclassResponsibility
!

create
    self subclassResponsibility
!

optionAt: option level: level size: size
    self subclassResponsibility
!

optionAt: option level: level put: anObject
    self subclassResponsibility
! !

!AbstractSocketImpl methodsFor: 'concrete'!

boundTo: ipAddress port: port
    localAddress := ipAddress.
    localPort := port
!

connectedTo: ipAddress port: port
    remoteAddress := ipAddress.
    remotePort := port
!

localAddress
    ^localAddress
!

localPort
    ^localPort
!

remoteAddress
    ^remoteAddress
!

remotePort
    ^remotePort
!

soLinger
    | data |
    data := self
        optionAt: self class soLinger
        level: self class solSocket
        size: CInt sizeof * 2.

    (data intAt: 1) = 0 ifTrue: [ ^nil ].
    ^data intAt: CInt sizeof + 1
!

soLinger: linger
    | data |
    data := ByteArray new: CInt sizeof * 2.
    linger isNil ifFalse: [
        data at: 1 put: 1.
        data intAt: CInt sizeof + 1 put: linger
    ].
    self
        optionAt: self class soLinger
        level: self class solSocket
        put: data
!

soReuseAddr
    ^((self optionAt: self class soReuseAddr size: CInt sizeof) intAt: 1) > 0
!

soReuseAddr: aBoolean
    self
        optionAt: self class soReuseAddr
        level: self class solSocket
        put: aBoolean
!

soTimeout
    ^(self
        optionAt: self class soTimeout
        level: self class solSocket
        size: CInt sizeof) intAt: 1
!

soTimeout: timeout
    self
        optionAt: self class soTimeout
        level: self class solSocket
        put: timeout
!

tcpNoDelay
    ^((self
        optionAt: self class tcpNoDelay
        level: self class ipprotoTcp
        size: CInt sizeof) intAt: 1) > 0
!

tcpNoDelay: aBoolean
    | value |
    value := aBoolean ifTrue: [ 1 ] ifFalse: [ 0 ].
    self
        optionAt: self class tcpNoDelay
        level: self class ipprotoTcp
        put: value
! !

