"======================================================================
|
|   Smalltalk TCP/IP sockets - Abstract socket class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

PositionableStream subclass: #AbstractSocket
	  instanceVariableNames: 'impl readBuffer writeBuffer'
	  classVariableNames: 'ReadBufferSize WriteBufferSize'
	  poolDictionaries: ''
	  category: 'Sockets-Streams'
!

AbstractSocket class instanceVariableNames: 'defaultImplementationClass'!

!AbstractSocket class methodsFor: 'accessing'!

defaultImplementationClass
    ^defaultImplementationClass
!

defaultImplementationClass: aClass
    defaultImplementationClass := aClass
!

readBufferSize
    ^ReadBufferSize
!

readBufferSize: anInteger
    ReadBufferSize := anInteger
!

writeBufferSize
    ^WriteBufferSize
!

writeBufferSize: anInteger
    WriteBufferSize := anInteger
! !

!AbstractSocket class methodsFor: 'instance creation'!

new: implementation
    ^super new initialize: implementation
!

new
    ^self new: self defaultImplementationClass new
! !

!AbstractSocket methodsFor: 'accessing'!

address
    self subclassResponsibility
!

atEnd
    ^self readBuffer atEnd
!

available
    ^readBuffer isFull or: [ self implementation available ]
!

close
    self flush.
    self implementation close.
!

flush
    self writeBuffer flush
!

localAddress
    ^self implementation soBindAddr
!

localPort
    ^self implementation localPort
!

next
    ^self readBuffer next
!

next: count
    ^self readBuffer next: count
!

nextPut: byte
    self writeBuffer nextPut: byte
!

nextPutAll: aByteArray
    self writeBuffer nextPutAll: aByteArray
!

port
    self subclassResponsibility
!

soTimeout
    ^self implementation soTimeout
!

soTimeout: timeout
    ^self implementation soTimeout: timeout
! !

!AbstractSocket methodsFor: 'printing'!

printOn: aStream
    aStream
        print: self class;
        nextPut: $[;
        print: self address;
        nextPut: $: ;
        print: self port;
        nextPutAll: ']'
! !

!AbstractSocket methodsFor: 'private'!

writeBuffer
    ^writeBuffer
!

implementation
    ^impl
!

initialize: implementation
    impl := implementation.

    writeBuffer := (WriteBuffer on: (String new: WriteBufferSize))
        flushBlock: [ :data :size | self implementation write: data numBytes: size ].

    readBuffer := (ReadBuffer on: (String new: ReadBufferSize))
        fillBlock: [ :data :size |
            [ self implementation available ] whileFalse: [ Processor yield ].
            self implementation read: data numBytes: size ]
! !
