Object subclass: #Timer
    instanceVariableNames: 'period doBlock stopBlock atStopBlock process '
    classVariableNames: ''
    poolDictionaries: ''
    category: 'Examples-Useful tools'!

!Timer methodsFor: 'accessing'!

atStopBlock
    ^atStopBlock
!

atStopBlock: aBlock
    atStopBlock := aBlock
!

doBlock
    ^doBlock
!

doBlock: aValue
    doBlock := aValue
!

stopBlock
    ^stopBlock
!

stopBlock: aValue
    stopBlock := aValue
!

period
    ^period
!

period: aValue
    period := aValue
! !

!Timer methodsFor: 'actions'!

resume
    process isNil ifFalse: [ process resume. ].
!

start
    process isNil ifFalse: [ ^self ].
    process := [ [ self stopBlock value ]
	    whileFalse: [
		(Delay forMilliseconds: self period) wait.
		doBlock value ].
       self atStopBlock isNil ifFalse: [ self atStopBlock value ].
       process := nil
    ] fork
!

stop
    process isNil ifFalse: [ process terminate. ].
    process := nil.
!

suspend
    process isNil ifFalse: [ process suspend. ].
! !

!Timer class methodsFor: 'instance-creation'!

every: milliseconds do: aBlock stopWhen: anotherBlock

    ^self new
	period: milliseconds;
	doBlock: aBlock;
	stopBlock: anotherBlock;
	start;
	yourself
!

every: milliseconds do: aBlock stopWhen: anotherBlock afterStopDo: stopBlock

    ^self new
	period: milliseconds;
	doBlock: aBlock;
	stopBlock: anotherBlock;
	atStopBlock: stopBlock;
	start;
	yourself
! !
