"Generate class definitions"

Object subclass: #GenClass
       instanceVariableNames: 'parent stream'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Examples-Useful tools'
!

!GenClass class methodsFor: 'execution'!

generate: onStream parent: parentName names: nameList prefix: aSymbol
    ^self new
        init: onStream
        parent: parentName
        names: nameList
        mangle: [ :name | aSymbol, name ]
!

generate: onStream parent: parentName names: nameList suffix: aSymbol
    ^self new
        init: onStream
        parent: parentName
        names: nameList
        mangle: [ :name | name, aSymbol ]
!

generate: onStream parent: parentName names: nameList
    ^self new
        init: onStream
        parent: parentName
        names: nameList
        mangle: [ :name | name ]
! !

!GenClass methodsFor: 'private'!

init: aStream parent: parentName names: nameList mangle: aBlock
    
    parent := parentName asString.
    stream := aStream.
    nameList do: [ :name |
        self generate: (aBlock value: name).
    ]
!

generate: name
    stream
        nextPutAll: parent;
        nextPutAll: ' subclass: #';
	nextPutAll: name;
        nl; nextPutAll: '    instanceVariableNames: '''' '
        nl; nextPutAll: '    classVariableNames: '''' '
        nl; nextPutAll: '    poolDictionaries: '''' ';
        nl; nextPutAll: '    category: ''no category'' !';
        nl; nl
! !
