"======================================================================
|
|   CompressedFileSegment Method Definitions
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Smalltalk at: #Compressor put: nil!

FileSegment subclass: #CompressedFileSegment
    instanceVariableNames: 'fileName startPos length'
    classVariableNames: ''
    poolDictionaries: ''
    category: 'Language-Implementation'
!

CompressedFileSegment comment: 
'My instances represent compressed sections of files.  I am primarily
used by the compiler to record source code locations.' !


!CompressedFileSegment class methodsFor: 'basic'!

newCompressing: aFile startingAt: startPos for: lengthInteger to: outFile
    | in out pos end |
    in := FileStream open: aFile mode: 'r'.
    in position: startPos.

    out := FileStream open: fileName mode: 'a'.
    out setToEnd.
    pos := out position.

    Compressor compress: in for: lengthInteger to: out.
    end := out position.
    in close.
    out close.

    ^super
        on: outFile
        startingAt: pos
        for: end - pos
!!



!FileSegment methodsFor: 'basic'!

asString
    "Answer a String containing the required segment of the file"
    | stream |
    stream := WriteStream on: (String new: self length * 2).
    Compressor decompress: super asString for: self length to: stream.
    ^stream contents
!!
