!Integer methodsFor: 'benchmarks'!

tinyBenchmarks
        "Report the results of running the two tiny Squeak benchmarks."
        "Squeak on a 292 MHz G3 Mac:       22.7 Mbytecodes/sec; 984 Ksends/sec"
        "Squeak on a 300 MHz PentiumII PC: 12.5 Mbytecodes/sec; 770 Ksends/sec"
        "GST on a 300 MHz PentiumII PC:    16.3 Mbytecodes/sec; 790 Ksends/sec"

        | n t1 t2 r |
        n _ 10.
        t1 _ Time millisecondsToRun: [n benchmark].
        t2 _ Time millisecondsToRun: [r _ 28 benchFib].
        ^ ((n * 500000 * 1000) // t1) printString, ' bytecodes/sec; ',
          ((r * 1000) // t2) printString, ' sends/sec'
!

benchFib  "Handy send-heavy benchmark"
        "(result // seconds to run) = approx calls per second"
        " | r t |
          t _ Time millisecondsToRun: [r _ 26 benchFib].
          (r * 1000) // t"
        "138000 on a Mac 8100/100"
        ^ self < 2
                ifTrue: [1] 
                ifFalse: [(self - 1) benchFib + (self - 2) benchFib + 1]
!

benchmark  "Handy bytecode-heavy benchmark"
        "(500000 // time to run) = approx bytecodes per second"
        "5000000 // (Time millisecondsToRun: [10 benchmark]) * 1000"
        "3059000 on a Mac 8100/100"
    | size flags prime k count |
    size _ 8190.
    1 to: self do:
        [:iter |
        count _ 0.
        flags _ (Array new: size) atAllPut: true.
        1 to: size do:
            [:i | (flags at: i) ifTrue:
                [prime _ i+1.
                k _ i + prime.
                [k <= size] whileTrue:
                    [flags at: k put: false.
                    k _ k + prime].
                count _ count + 1]]].
    ^ count
! !

Transcript showCr: 0 tinyBenchmarks!
