"======================================================================
|
|   Smalltalk lexical token definitions.
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #STToken
       instanceVariableNames: 'line'
       classVariableNames: ''
       poolDictionaries:''
       category: 'System-Compiler'
!

STToken comment:
'My instances are returned from the lexer stream.  If you ask them (nicely,
mind you) they will report their kind (through messages like #isSTDotTok) and
sometimes their value (such as ''foobar'').'!

STToken subclass: #STValueToken
      instanceVariableNames: 'value'
      classVariableNames: ''
      poolDictionaries: ''
      category: 'System-Compiler'
!

!STToken class methodsFor: 'subclass creation'!

defineSubclasses: classNames
    | method class |
    method := 'is%1
        ^%2'.

    classNames do: [ :className |
        | class |
        class := self subclass: className
	    instanceVariableNames: ''
	    classVariableNames: ''
	    poolDictionaries: ''
	    category: 'System-Compiler'.

        class compile: (method bindWith: className with: 'true') classified: 'testing'.
        STToken compile: (method bindWith: className with: 'false') classified: 'testing'
    ]
! !

!STToken class methodsFor: 'instance creation'!

new: location
     ^self new line: location
! !

!STToken methodsFor: 'accessing'!

= differentToken
    ^self class == differentToken class
!

hash
    ^self class hash
!

line
    ^line
!

line: lineNo
    line := lineNo
!

printOn: aStream
    aStream
        nextPut: $< ;
        print: self class;
        nextPut: $>.
! !


!STValueToken class methodsFor: 'instance creation'!

new: location value: aValue
     ^(self new: location) init: aValue
! !

!STValueToken methodsFor: 'accessing'!

= differentToken
    ^self class == differentToken class and: [ value = differentToken value ]
!

hash
    ^value hash
!

printOn: aStream
    aStream
        nextPut: $< ;
        print: self class;
        nextPut: $: ;
        print: self value;
        nextPut: $>.
!

value
    ^value
! !

!STValueToken methodsFor: 'private'!

init: aValue
    value := aValue
! !

STToken defineSubclasses:
    #(STDotTok 			STVerticalBarTok
      STBangTok			STSharpTok
      STColonTok		STOpenParenTok
      STCloseParenTok		STSemiTok
      STOpenBracketTok		STCloseBracketTok
      STUpArrowTok		STAssignTok 
      STPrimitiveStartTok).

STValueToken defineSubclasses:
    #(STSymbolTok		STCommentTok
      STLiteralTok		"string, integer, float, character"
      STIdentifierTok		STKeywordTok
      STSymbolKeywordTok	STBinopTok)
!

!STVerticalBarTok methodsFor: 'accessing'!

value
    ^'|'
! !

!STBangTok methodsFor: 'accessing'!

value
    ^'!'
! !
