"======================================================================
|
|   Smalltalk in Smalltalk compiler symbol table
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #STSymbolTable
       instanceVariableNames: 'variables tempCount literals pools instVars environment scopes'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'System-Compiler'
! 

!STSymbolTable class methodsFor: 'instance creation'!

new
    ^super new init
! !

!STSymbolTable methodsFor: 'declaring'!

declareEnvironment: aBehavior

    | i |
    environment := aBehavior.

    i := 0.
    aBehavior allInstVarNames do: [ :iv |
        instVars at: iv asSymbol put: (i := i + 1).
    ].
    self declareGlobals
!

declareGlobals
    | behavior |
    behavior := environment.

    "Find a suitable Class object from the given behavior"
    behavior isMetaclass ifTrue: [ behavior := behavior instanceClass ].

    [ behavior isClass ] whileFalse: [
        behavior := behavior superclass.
        behavior isNil ifTrue: [ ^self ]
    ].

    behavior withAllSuperclassesDo: [ :class |
        class classPool isEmpty ifFalse: [
            pools add: class classPool
        ]
    ].

    behavior allSharedPools do: [ :sp |
        pools add: (Smalltalk at: sp).
    ].
!

declareTemporary: tempName isArgument: arg for: stCompiler
    | ok |
    ok := false.
    variables at: tempName asSymbol ifAbsentPut: [
        ok := true.
        STVariable
            id: tempCount
            scope: scopes size
            isArgument: arg
    ].
    ok ifFalse: [
        stCompiler compileError: 'duplicate variable name ', tempName
    ].
    tempCount := tempCount + 1.
    ^tempCount - 1
!

scopeEnter
    scopes add: tempCount.
    tempCount := 0.
!

scopeLeave
    tempCount := scopes removeLast.
!

undeclareTemporary: tempName
    variables removeKey: tempName asSymbol ifAbsent: [ ].
!

addLiteral: aLiteral
    "Answers the index of the given literal.  If the literal is already 
     present in the literals, returns the index of that one."

    ^literals at: aLiteral ifAbsentPut: [ literals size ]
! !

!STSymbolTable methodsFor: 'accessing'!

canStore: aName
    variables at: aName asSymbol ifPresent: [ :var |
        ^var canStore
    ].
    ^true
!

numTemps
    ^tempCount
!

isTemporary: aName
    ^variables includesKey: aName asSymbol
!

isReceiver: aName
    ^instVars includesKey: aName asSymbol
!

outerScopes: aName
    variables at: aName asSymbol ifPresent: [ :value |
        ^scopes size - value scope
    ].
    ^nil
!

lookupName: aName
    "Answers a value for the name"
    | symbol |
    (Symbol isSymbolString: aName) ifFalse: [ ^nil ].
    symbol := aName asSymbol.

    variables at: symbol ifPresent: [ :value | ^value id ].

    instVars at: symbol ifPresent: [ :value | ^value - 1 ].

    pools do: [ :pool |
        | assoc |
        assoc := pool associationAt: symbol ifAbsent: [ nil ].
        assoc isNil ifFalse: [ ^self addLiteral: assoc ]
    ].
    ^nil
!

literals
    | array |
    array := Array new: literals size.
    literals keysAndValuesDo: [ :literal :index |
        array at: index + 1 put: literal
    ].
    ^array
! !


!STSymbolTable methodsFor: 'private'!

init
    variables := Dictionary new: 0.
    literals := Dictionary new: 0.
    instVars := Dictionary new: 7.
    scopes := OrderedCollection new: 5.
    pools := Set new: 7.
    tempCount := 0.
! !
