"======================================================================
|
|   Smalltalk in Smalltalk compiler - code to enable the compiler
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"



STParser subclass: #STFileInParser
       instanceVariableNames: 'curCategory curClass curCompilerClass evalFor lastResult method'
       classVariableNames: 'CurrentParser'
       poolDictionaries: ''
       category: 'System-Compiler'
!

STFileInParser comment:
'I am a STParser that compiles code that you file in.'!

!STFileInParser class methodsFor: 'accessing'!

methodsFor: aString ifTrue: realCompile class: aClass
    CurrentParser isNil ifFalse: [
        ^CurrentParser
            methodsFor: aString 
            ifTrue: realCompile
            class: aClass
    ].
    ^aClass basicMethodsFor: aString ifTrue: realCompile
! !



!STFileInParser methodsFor: 'accessing'!

evalFor: anObject
    evalFor := anObject
!

lastResult
    ^lastResult
!

methodsFor: aString ifTrue: realCompile class: aClass
    curCategory := aString.
    curClass := aClass.
    curCompilerClass := realCompile
        ifTrue: [ STCompiler ]
        ifFalse: [ STFakeCompiler ]
!

parseSmalltalk
    | previousParser result |
    previousParser := CurrentParser.
    CurrentParser := self.

    super parseSmalltalk.

    CurrentParser := previousParser.
    ^method
! !

!STFileInParser methodsFor: 'overrides'!

compile: node
    method := curCompilerClass
	compile: node
	for: curClass
	classified: curCategory
	parser: self.
!

endMethodList
    curClass := nil
!

evaluate: node
    | selector |
    selector := node selector selector.

    STDoitCompiler
	compile: node
	for: evalFor class
	classified: nil
	parser: self.

    [ lastResult := evalFor perform: selector ] valueWithUnwind.
    evalFor class removeSelector: selector ifAbsent: [ ].
    ^curClass notNil
!

record: string
    "Transcript nextPutAll: string; nl"
! !

"Final definitions to start the compiler..."

!FileStream methodsFor: 'file-in'!

fileIn
    (STFileInParser onStream: self) parseSmalltalk
! !

!Behavior methodsFor: 'compiling'!

evalString: aString to: anObject
    ^(STFileInParser onStream: (ReadStream on: aString))
        evalFor: anObject;
        parseSmalltalk;
        lastResult
!

evalString: aString to: anObject ifError: aBlock
    | parser |
    ^(parser := STFileInParser onStream: (ReadStream on: aString))
        evalFor: anObject;
        parseErrorBlock: [ :f :l :m |
            parser close.
            ^aBlock value: f value: l value: m.
        ];
        parseSmalltalk;
        lastResult
!

compileString: aString

    | codeWithHeader |
    codeWithHeader := '!%1 methodsFor: nil!%2!!'
        bindWith: self printString
        with: aString.

    ^(STFileInParser onStream: (ReadStream on: codeWithHeader)) parseSmalltalk
!

compileString: aString ifError: aBlock
    | parser codeWithHeader |
    codeWithHeader := '!%1 methodsFor: nil!
%2!!'
        bindWith: self name
        with: aString.

    ^(parser := STFileInParser onStream: (ReadStream on: codeWithHeader))
        parseErrorBlock: [ :f :l :m |
            parser close.
            ^aBlock value: f value: l - 1 value: m.
        ];
        parseSmalltalk
!

basicMethodsFor: category ifTrue: condition
    "Compile the following code inside the receiver, with the given category,
     if condition is true; else ignore it - included just to be sure"
    <primitive: 151>
    ^self primitiveFailed
!

methodsFor: aString
    STFileInParser methodsFor: aString ifTrue: true class: self
!

methodsFor: aString ifTrue: realCompile
    STFileInParser methodsFor: aString ifTrue: realCompile class: self
! !
