@echo off
echo Building GNU Smalltalk
echo.

:: Set up a command line
:: Change the following six lines for another compiler; note that this
:: batch file WON'T produce a library - only an executable
::
set $ccexe$=gcc -c
set $ldexe$=gcc -o
set $ccarg$=-mcpu=i686 -DHAVE_CONFIG_H -I. -I./lib -Wall -Wno-parentheses -Wno-switch
set $ldarg$=gst.exe *.o
set $cdebug$=-g
set $optdebug$=-finline -funroll-loops -fomit-frame-pointer

set $files$=main.c lib\*.c cfuncs.c
set $path$=-DIMAGE_PATH="/usr/local/gst/1.6" -DKERNEL_PATH="/usr/local/gst/1.6/kernel"

set $cleanup$=

:: Add parameters to compile various modules
::
:: Special cased options:
:: CC and LD cause an extra parameter shift
:: ONLY ends the loop; the remaining parameters replace the default $FILES$
:: NOLINK remains in the environment until the end of the file,
:: so we must change it to a plus so that it jump to getopt only the first
:: time.

:getopt
if '%$NOLINK$%'=='*' set $NOLINK$=+
if '%$CC$%%$LD$%'=='*' shift
shift
set $cc$=
set $ld$=

if '%0'=='' goto compile
set $%0$=*

if '%$BISON$%'=='*' cd lib & bison -dv gst.y & cd..
if '%$BLOX$%'=='*' set $ccarg$=-DUSE_BLOX %$ccarg$%
if '%$BLOX$%'=='*' set $files$=blox\blox.c %$files$%
if '%$BLOX$%'=='*' set $ldarg$=%$ldarg$% -ltcl80 -ltk80 
if '%$RL$%'=='*' set $ccarg$=-DHAVE_READLINE %$ccarg$%
if '%$RL$%'=='*' set $ldarg$=%$ldarg$% -lreadline -ltermcap
if '%$OPT$%'=='*' set $ccarg$=-DOPTIMIZE -O3 %$ccarg$%
if '%$DEBUG$%'=='*' set $optdebug$=%$cdebug$%
if '%$CLEAN$%'=='*' set $cleanup$=del *.o*

if '%$NOLINK$%'=='*' goto getopt

if '%$CC$%'=='*' set $ccarg$=%1 %$ccarg$%
if '%$LD$%'=='*' set $ldarg$=%1 %$ldarg$%
if '%$ONLY$%'=='*' goto getfiles

if '%$CC$%%$LD$%'=='*' goto getopt
set $%0$=
goto getopt

:getfiles
set $only$=
set $files$=%1
shift

:getfiles2
if '%1'=='' goto compile
set $files$=%$files$% %1
shift
goto getfiles2

:compile
if not exist gsticon.o (
  echo ProgramIcon ICON gsticon.ico > tmp.rc
  windres -i tmp.rc -O coff gsticon.o
  del tmp.rc
)

:: Cmdline parsed, compile now
echo %$ccexe$% %$optdebug$% %$path$% %$ccarg$%
echo.
for %%i in (%$files$%) do (
  echo %%i
  %$ccexe$% %$optdebug$% %$path$% %$ccarg$% %%i
)
del dld_none.o

:: Link if necessary now
if '%$NOLINK$%'=='+' goto cleanup
echo.
echo %$ldexe$% %$ldarg$%
%$ldexe$% %$ldarg$%

:cleanup
%$cleanup$%
set $cleanup$=
set $cdebug$=
set $optdebug$=
set $nolink$=
set $ccarg$=
set $ldarg$=
set $ccexe$=
set $ldexe$=
set $files$=

:: But you better use bash:
::	./modules $*
:: 	make
