"File GuiData.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

!Gui methodsFor: 'change management'!

changeState: anObject
    "log change"
    ^self subclassResponsibility
!

getCurrentState
    "default; override if necessary"
    ^self deepCopy
!

getStateChanges: viewState
    "compare self with viewState and return object describing differences"
    ^self subclassResponsibility
!!

Gui subclass: #GuiData
    instanceVariableNames: 'checkpoints'
    classVariableNames: ''
    poolDictionaries: ''
    category: 'Graphics-Windows'
!

!GuiData methodsFor: 'change management'!

changeState: anObject
"Record the state change denoted by anObject"
    | updateCount|
    checkpoints isNil ifTrue: [checkpoints := Dictionary new].
    updateCount := checkpoints at: anObject ifAbsent: [0].
    checkpoints at: anObject put: (updateCount + 1) \\ 1e6.
!

checkpoints
    ^checkpoints.
!

getCurrentState
   ^checkpoints
!

getStateChanges: viewState
"Compare current state with viewState and return an object which describes
diffences"
| stateChanges subStateValue stateChange|
  stateChanges := Set new.
        (viewState isNil | checkpoints isNil) ifTrue: [^nil].
        viewState keysDo: [ :viewSubState | subStateValue := checkpoints at: viewSubState ifAbsent: [0].
          (subStateValue > ((viewState at: viewSubState) at: #counter))
                ifTrue: [ stateChange := Dictionary new. stateChange at: #state put: viewSubState. stateChange at: #counter put: subStateValue. stateChanges add: stateChange. ]
        ].
  ^stateChanges.
!!


