/***********************************************************************
 *
 *  Blox
 *
 *  Standardized, Tk-based GUI widgets available for various window
 *  systems - Interface to Tcl
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>
#include <tk.h>
#include "gst.h"
#include "gstpub.h"
#include "oop.h"

static Tcl_Interp *tclInit();
static int doCallback();
static void bloxIdle();
static Tcl_Interp *interp;

void
initBlox()
{
  defineCFunc("Tcl_Eval", Tcl_Eval);
  defineCFunc("Tcl_GetStringResult", Tcl_GetStringResult);
  defineCFunc("tclInit", tclInit);
  defineCFunc("bloxIdle", bloxIdle);
}

static void
bloxIdle()
{
  Tcl_DoOneEvent(TCL_ALL_EVENTS | TCL_DONT_WAIT);
}

static int
doCallback(clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp *interp;
     int argc;
     char *argv[];
{
  OOP oop, *args;
  int i;

  /* argv[0] is "callback", the command name */
  args = alloca(sizeof(OOP) * (argc - 2));
  oop = oopAt(atoi(argv[1]));
  for (i=0;i<argc-3;i++) {
    args[i] = stringToOOP(argv[i+3]);
  }
  args[argc - 3] = NULL;
  if (vmsgSend(oop, symbolToOOP(argv[2]), args) == trueOOP) {
    Tcl_SetResult(interp, "1", TCL_STATIC);
  } else {
    Tcl_SetResult(interp, "0", TCL_STATIC);
  }

  return TCL_OK;
}

Tcl_Interp *
tclInit()
{
  if (interp) {
    return(NULL);
  }

  interp = Tcl_CreateInterp();
  if (Tcl_Init(interp) == TCL_ERROR) {
    fprintf(stderr, "Tcl_Init failed: %s\n", interp->result);
    exit(1);
  }
  if (Tk_Init(interp) == TCL_ERROR) {
    fprintf(stderr, "Tk_Init failed: %s\n", interp->result);
    exit(1);
  }
  Tcl_CreateCommand(interp, "callback", doCallback, NULL, NULL);

  return (interp);
}
