/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/*
 * Name          : pips/src/pipsReadPnmHeader.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   pipsReadPnmHeader (file, width, height)
 *
 *   FILE* file     IS   Stream containing the image data
 *   long *width    IS   The width of a recognized image
 *   long *height   IS   The height of a recognized image
 * 
 * Description   : 
 *
 *   Identifies the type of image in the stream 'file', which has to
 *   be open, and reads the header up to the data body.
 *   The width and height are returned in 'width' and 'height' resp.
 *   The function returns a symbol for the image type (see pips.h)
 *   If the image is not recognized or the stream is empty, then 'width'
 *   and 'height' are unchanged and PipsUnknown or EOF is returned.
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int pipsReadPnmHeader (FILE *file,
                        long *width, long *height)

#else

pipsReadPnmHeader (file, width, height)
    FILE *file;
    long *width;
    long *height;

#endif
{
  int imgType = PipsUnknown;      /* Detected image type              */
  int colours;                    /* Maximum number of colours        */

/*
 * Read image type tag
 */
  if (fscanf (file, "P%1d", &imgType) == EOF)
    return (EOF);

/*
 * Identify image type, exit, if unknown
 */
  if ((imgType < 1) || (imgType > 6) || (imgType == PipsPbmRaw))
    return (PipsUnknown);

/*
 * Read width, height and number of colours of PBM, PGM, PPM,
 * skipping all comment lines between them, that is '# bla bla ... (newline)'
 */
  while (! fscanf (file, "%lu", width))	  /* If a number could not be read ..*/
    fscanf (file, "%*[^\n]");	   		  /* ... skip the rest of the line   */
  while (! fscanf (file, "%lu", height))
    fscanf (file, "%*[^\n]");
/*
 * There is no number of colours in pbm files
 */
  if ((imgType != PipsPbmAscii) && (imgType != PipsPbmRaw))
    while (! fscanf (file, "%u", &colours))
      fscanf (file, "%*[^\n]");

  fscanf (file, "\n");			   		  /* Read the trailing (newline)     */

  return (imgType);
} /* pipsReadPnmHeader */


/* end pipsReadPnmHeader.c */
