/*
* (C) 2000, 2001 David O'Toole $Date: 2001/03/24 22:30:45 $
* $Revision: 1.2 $
* 
* ENGINE.H
* Header for engine model data, intrinsic functions, and Control update interface
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*
*/

#ifndef _engine_h_
#define _engine_h_ 

#include "machine.h"
#include <pthread.h>

enum { max_machines = 128 };    /* per signal network               */ 
enum { master };
enum _sig_type {en_nosignal, en_normal, en_aux}; /* types of signals in the network  */ 
typedef enum _sig_type sig_type; 

struct _mx_action; // forward reference


//
// ENGINE DATA MODEL
//


struct _engine {

	mutex_t mutex;

	machine *machines[max_machines];
	sig_type signals[max_machines][max_machines]; 

	samp lmix[OX_OUTPUT_BUFFER_SIZE];  
	samp rmix[OX_OUTPUT_BUFFER_SIZE];
	struct _mx_action *program;
	
	int last_machine;	// index of last machine, needed because there may be holes
	long frame; 
	long tick;        	// current position in song             
	int tickpos;      	// current position within current tick 
 
	int tick_size;    	// derived from tpb and bpm                         
	int block_size;   	// set to be small enough for low-latency         
	int tpb;         	// ticks per beat                                   
	int bpm;          	// beats per minute                                
};

typedef struct _engine engine; 

// 
// PUBLIC FUNCTIONS.  
// Synchronization is the responsibility of the caller. 
//

machine* en_get_machine(engine* e, int m);
int      en_is_present(engine* e, int which_machine);  // is there a machine there? 
int      en_is_connected(engine* e, int source, int sink);
void     en_rep(engine* dest, engine *src);
void 	 en_reset_program(engine *en);

engine*  en_create(void);

//
// THINGS THE VIEW CLIENT(S) WILL TYPICALLY WANT TO CALL
//

void en_position    (engine *self, int mid, int x, int y);
int  en_connect     (engine *self, int sigtype, int source, int sink);
void en_name        (engine *self, int mid, const char *newname);
void en_pan         (engine *self, int source, int sink, param value);
void en_amp         (engine *self, int source, int sink, param value);
void en_set_timings (engine *self, int block_size, int tpb, int bpm);
int  en_add         (engine *self, machine *m); 
void en_remove		(engine *self, int mid);
void en_event		(engine *self, int mid, int track, int param_ix, param value);

machine_type *en_get_type_from_index(engine *e, int ix);


#include "mixer.h"

#endif /*_engine_h_*/


