// decorators for html

#ifndef _DECORATOR_H
#define _DECORATOR_H

#include "textgen.h"
#include "tags.h"
#include "colors.h"

class TagDecorator : public TextDecorator {
  protected :
    char *tag ;
    char *attr ;
    char *val ;

  public :
    TagDecorator( TextGenerator *t, char *ta, char *a = NULL, char *v = NULL )
    : TextDecorator( t ), tag(ta), attr(a), val(v) {}
  
  virtual void startDecorate() const { startTAG( tag, attr, val ) ; }
  
  virtual void endDecorate() const { endTAG( tag ) ; }

  protected :
    void startTAG( char *tag, char *attr, char *val ) const {
      (*sout) << "<" << tag ;
      if ( attr && val )
	(*sout) << " " << attr << "=" << val ;
      (*sout) << ">" ;
    }

    void endTAG( char *tag ) const {
      (*sout) << "</" << tag << ">" ;
    }
} ;

class ColorDecorator : public TagDecorator {
  public :
    ColorDecorator( TextGenerator *t, char *color ) :
      TagDecorator( t, FONT_TAG, COLOR_TAG, color ) {}
} ;

class SpanDecorator : public TextDecorator {
  protected :
    char *span ;

  public :
    SpanDecorator( TextGenerator *t, char *ta)
    : TextDecorator( t ), span(ta) {}

  virtual void startDecorate() const { startTAG( span ) ; }

  virtual void endDecorate() const { endTAG( ) ; }

  protected :
    void startTAG( char *span ) const {
      (*sout) << "<span class=\"" << span << "\">" ;
    }

    void endTAG( ) const {
      (*sout) << "</span>" ;
    }
} ;

#endif
