#ifndef CONFIG_H
#define CONFIG_H

/* The default wordlist to use, if you pass NULL or "" to wcomp_open(). */

#ifndef DEFAULT_WORDLIST
#define DEFAULT_WORDLIST "/usr/dict/words"
#endif

/* Define this to read the wordlist line by line, and malloc() space for
each word.  This will work better if the wordlist doesn't use \n newlines. */

/* #define BUFFER_WORDLIST 1 */

/* The comparison function.  Currently this only affects the splay tree
order; the initial_match() and is_prefix() functions don't consider case.
Even if the comparison function doesn't match the sort order of the wordlist
everything will still work. */

/* #define CMP(a, b) (strcasecmp(a, b)) */
#define CMP(a, b) (strcmp(a, b))

/* The maximum size of the "top ten list".  Words are inserted into this
list using a linear insertion sort, so we place an arbitrary limit on its
size.  Don't change this one, change the next one. */

#ifndef MAXTOPLEN
#define MAXTOPLEN 100
#endif

/* The default size of the "top ten list".  It can be as large as MAXTOPLEN.
This default can be overridden using wcomp_set_topnlist_size(). */

#ifndef TOPLEN
#define TOPLEN 10
#endif

#endif /* CONFIG_H */


