/* 
   Controller.h

   Controller class for the GNUstep Interface Modeller

   Copyright (C) 1996, 1997 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Date: August 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: Sept 1998
   
   This file is part of the GNUstep Interface Modeller.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_Controller
#define _GNUstep_H_Controller

#include <Foundation/NSObject.h>
#include <Foundation/NSArray.h>

@class NSTextField;


@interface Controller : NSObject

{
	id paint_panel;									 				// Panels
	id palettePanel;												
	id inspector_panel;
  
	NSTextField* textfield;
	BOOL testInterface;
 									
	NSMutableArray *user_models;	// List of user model files (the documents)
}

//
// Instance methods
//
													// Display the panels
- (void)showPaintPanel:sender;
- (void)showPalettePanel:sender;
- (void)showInspectorPanel:sender;

													// Working with model files
- (void)newModelFile:sender;
- (void)openModelFile:sender;
- (void)closeModelFile:sender;
- (void)saveModelFile:sender;
- (void)saveAsModelFile:sender;

- (void)method:menuCell;							// temp for sake of menu
- (void)setTestInterface:(id)sender;
- (BOOL)testInterface;

@end

#endif // _GNUstep_H_Controller
