/* 
   XRImage.m

   NSImage for GNUstep GUI X/RAW Backend.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@colorado.edu>
   Date: Feb 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <gnustep/xraw/XR.h>
#include <AppKit/NSColor.h>
#include <gnustep/xraw/XRImage.h>
#include <gnustep/xraw/XRView.h>
#include <gnustep/xraw/XRScreen.h>
#include <gnustep/xraw/XRWindow.h>
#include <gnustep/xraw/XRCachedImageRep.h>

extern void NSDrawImage(NSImageRep *imageRep, NSRect rect);
extern void XRDrawXImage(NSImageRep *imageRep, NSRect rect);



@implementation XRImage

- (void) lockFocusOnRepresentation: (NSImageRep *)imageRep
{
	[super lockFocusOnRepresentation: imageRep];
}

- (BOOL)drawRepresentation:(NSImageRep *)imageRep inRect:(NSRect)rect
{
	if([super drawRepresentation:imageRep inRect:rect])
		{									  
		NSRect r = rect;
		if (_flags.scalable) 			
			r.origin = NSZeroPoint;
	
		[_color set];
		NSRectFill(r);										// fill background
		XRDrawXImage([imageRep xImage], rect);				// Draw image from
		}     												// cache
	
	return YES;
}

- (Class) classForCoder: aCoder
{
  if ([self class] == [XRImage class])
    return [super class];
  return [self class];
}

@end
