;;; /***************************************************************************
;;; *
;;; *
;;; * Copyright (C) 2016, 2017 ng0 <contact.ng0@cryptolab.net>.
;;; *
;;; * This file is an appendum to gnurl. The author isn't clear about
;;; * licensing, so in case there are problems, contact them.
;;; *
;;; * This software is licensed as described in the file COPYING, which
;;; * you should have received as part of this distribution. The terms
;;; * are also available at https://curl.haxx.se/docs/copyright.html.
;;; *
;;; * You may opt to use, copy, modify, merge, publish, distribute and/or sell
;;; * copies of the Software, and permit persons to whom the Software is
;;; * furnished to do so, under the terms of the COPYING file.
;;; *
;;; * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
;;; * KIND, either express or implied.
;;; *
;;; ***************************************************************************/


(use-modules
 (ice-9 popen)
 (ice-9 match)
 (ice-9 rdelim)
 (guix packages)
 (guix build-system gnu)
 (guix gexp)
 ((guix build utils) #:select (with-directory-excursion))
 (gnu packages)
 (gnu packages base)
 (gnu packages autotools)
 (gnu packages gnunet))

(define %source-dir (dirname (current-filename)))

;; Taken from https://gitlab.com/dustyweb/pubstrate/blob/master/guix.scm
(define git-file?
  (let* ((pipe (with-directory-excursion %source-dir
                 (open-pipe* OPEN_READ "git" "ls-files")))
         (files (let loop ((lines '()))
                  (match (read-line pipe)
                    ((? eof-object?)
                     (reverse lines))
                    (line
                     (loop (cons line lines))))))
         (status (close-pipe pipe)))
    (lambda (file stat)
      (match (stat:type stat)
        ('directory #t)
        ((or 'regular 'symlink)
         (any (cut string-suffix? <> file) files))
        (_ #f)))))

(define-public gnurl-git
  (package
    (inherit gnurl)
    (name "gnurl-git")
    (version (string-append "7.53.1-" "dev"))
    (source
     (local-file %source-dir
                 #:recursive? #t))))
    ;;#:select? git-file?))

gnurl-git
