/*
     This file is part of GNUnet.
     (C) 2012 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/setup/gnunet-setup-gns.h
 * @brief gns interaction management
 * @author Christian Grothoff
 */
#ifndef GNUNET_SETUP_GNS_H
#define GNUNET_SETUP_GNS_H

#include "gnunet-setup.h"


/**
 * Connect to the namestore and initialize the main
 * GNS tree view.
 */
void
GNUNET_SETUP_gns_init (void);


/**
 * Disconnect from the namestore and clean up the main
 * GNS tree view.
 */
void
GNUNET_SETUP_gns_done (void);

#endif
