#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# uidrivers/html/widgets/form.py
#
# DESCRIPTION:
#
# NOTES:
#

import string, struct

from gnue.forms.uidrivers.html.widgets._base import UIHelper, HtmlWidget
# from gnue.forms.uidrivers.html.MenuBar import MenuBar
# from gnue.forms.uidrivers.html.ToolBar import ToolBar
from gnue.forms.uidrivers.html.common import *


class UIForm(UIHelper):

    def __init__(self, event):
        self._uiPageList=[]
        UIHelper.__init__(self, event)
        self.controls = []

    def _create_widget(self, event, spacer):
        object = event.object
        #
        # Size based upon the form definition
        #

        formWidth = int(self._form._layout.Char__width)
        formHeight = int(self._form._layout.Char__height)
        self._visibleSize = (formWidth*self._uiDriver.widgetWidth,
                          formHeight*self._uiDriver.widgetHeight)

        self._formSize = formSize = (formWidth*self._uiDriver.widgetWidth,
                          formHeight*self._uiDriver.widgetHeight)

        dhtml = u""
        if self._form.style == 'dialog':
            newWidget = HtmlWidget(event.container, self._uiDriver, 'DIALOG', dhtml, getNextId())
            # FIXME: add dialogs
        else:
            newWidget = HtmlWidget(event.container, self._uiDriver, 'FORM', dhtml, getNextId())

        self.mainWindow = newWidget
        self.mainWindow.updates = []

        # Add the menu
        # if not self._form._features['GUI:MENUBAR:SUPPRESS']:
        #     MenuBar(self._uiDriver, self.mainWindow, self._form)

        # and the Toolbar
        # if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
        #     ToolBar(self._uiDriver, self.mainWindow, self._form)

        dhtml = "<hr/>"
        HtmlWidget(self.mainWindow, self._uiDriver, 'LINE', dhtml, getNextId())

        self._uiDriver._htmlapp.setForm(self.mainWindow)
        self._container = newWidget
        return newWidget


    def _ui_show_(self, modal):
        pass


    # ---------------------------------------------------------------------------
    # Get HTML representation of current window
    # ---------------------------------------------------------------------------

    def get_html(self):
        # FIXME: updates should be cleared (Enable again after fixing enabling/disabling of widgets
        # self.mainWindow.updates = []
        return self.mainWindow.get_html()

    def get_updates(self):
        updates = self.mainWindow.updates
        self.mainWindow.updates = []
        return updates


    # ---------------------------------------------------------------------------
    # Set the forms title
    # ---------------------------------------------------------------------------

    def _ui_set_title_(self, title):
        self.mainWindow.set_title(title)


    # ---------------------------------------------------------------------------
    # Makes the requested page visible while hiding the others
    # ---------------------------------------------------------------------------

    def _ui_goto_page_ (self, page):
        self.mainWindow.updates.append(["goto_page","",page._container._id])


    # ---------------------------------------------------------------------------
    # Show a tip in the status bar. Used by the menu.
    # ---------------------------------------------------------------------------

    def _show_tip (self, tip):
        pass
        # FIXME: has to be implemented on client side


    # ---------------------------------------------------------------------------
    # User feedback functions
    # ---------------------------------------------------------------------------

    def _ui_begin_wait_(self):
        self.mainWindow.updates.append(["wait","",True])

    # ---------------------------------------------------------------------------

    def _ui_end_wait_(self):
        self.mainWindow.updates.append(["wait","",False])

    # ---------------------------------------------------------------------------

    def _ui_beep_(self):
        self.mainWindow.updates.append(["beep","",""])

    # ---------------------------------------------------------------------------

    def _ui_update_status_ (self, tip, record_status, insert_status,
            record_number, record_count, page_number, page_count):

        # TODO:  create and update status bar
        pass


    # ---------------------------------------------------------------------------
    # create a modal message box
    # ---------------------------------------------------------------------------

    def _ui_show_message_(self, message, kind, title, cancel):
        """
        This function creates a message box of a given kind and returns True, False
        or None depending on the button pressed.

        @param message: the text of the messagebox
        @param kind: type of the message box. Valid types are 'Info', 'Warning',
            'Question', 'Error'
        @param title: title of the message box
        @param cancel: If True a cancel button will be added to the dialog
        @return: True if the Ok-, Close-, or Yes-button was pressed, False if the
            No-button was pressed or None if the Cancel-button was pressed.
        """

        result=True
        if cancel or kind=="Question":
            id=23242
            self.mainWindow.updates.append(["message",id,[message,kind, title, cancel]])
            result=self.mainWindow.controller.waitResult(id)
        else:
            self.mainWindow.updates.append(["alert",title,message])

        return result


    # ---------------------------------------------------------------------------
    # Display an about box
    # ---------------------------------------------------------------------------

    def _ui_show_about_(self, name, version, author, description):
        message=u_("GNUe Forms:\nName: %s\nVersion: %s\nAuthor: %s\n" \
                   "Description: %s") % (name, version, author, description)
        self.mainWindow.updates.append(["alert","About",message])

    # ---------------------------------------------------------------------------
    # Print form screenshot
    # ---------------------------------------------------------------------------

    def _ui_printout_(self, title, subtitle, user):
        message = u_("Printout currently not supported")
        self.mainWindow.updates.append(["alert","Info",message])


    # ---------------------------------------------------------------------------
    # Close the window (actually only hide it)
    # ---------------------------------------------------------------------------

    def _ui_close_(self):

        self._visible = False
        self.mainWindow.updates.append(["close","",""])
        #FIXME: implement close dialog

    # ---------------------------------------------------------------------------
    # Event handlers
    # ---------------------------------------------------------------------------

    def _on_switch_page(self, page_number):

        assert gDebug(6, "switch-page to %r" % page_number)
        self._form._event_page_changed(page_number)

    # ---------------------------------------------------------------------------

    def _on_focus_in_event(self):
        # called if window is changed back to this form

        assert gDebug(6, "focus-in-event %s" % (self.form))
        self._form._event_focus_changed(None, 0)


configuration = {
    'baseClass'  : UIForm,
    'provides'   : 'GFForm',
    'container'  : 1,
  }
