/*
 *  Queue load balancing system
 *  $Revision: 1.1.1.3 $
 *
 *  Copyright (C) 1998 Werner G. Krebs
 *  ReadHosts() Copyright (C) 1998 Free Software Foundation, Inc.
 *
 *  werner.krebs@yale.edu 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  If you make modifications to the source, I would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *      Werner G. Krebs	      				
 *	werner.krebs@yale.edu
 *
 **************************************************************************/

#define sethosts 1
#include "queue.h"

int
ReadHosts(char *HostFile)
{

  /*Routine to parse hosts from a file, by Dave van Leeuwen*/

    FILE *QHosts;
#define TmpStrSize 256
    char TmpStr[TmpStrSize];
    int i;

    {

      /*WGK make sure HostFile is owned by us and has restricted write permissions.*/
      struct stat sbuf;
      stat(HostFile, &sbuf);

#ifdef NO_ROOT
      if (sbuf.st_uid != getuid())
	fprintf(stderr, "%s is not owned by the appropriate user uid: %d\n",
		HostFile,getuid()), exit(1);
#else
      if (sbuf.st_uid != 0)
	fprintf(stderr, "%s is not owned by the appropriate user uid: %d\n",
		HostFile,0), exit(1);
#endif
      if ((sbuf.st_mode & S_IWGRP) | (sbuf.st_mode & S_IWOTH))
	fprintf(stderr, "%s: mode %03o allows general or group write\n",
		 HostFile, sbuf.st_mode), exit(1);
    }

    if((QHosts = fopen(HostFile,"r")) == NULL)
    {
      fprintf(stderr,"ERROR cannot open host file %s\n",HostFile);
      return(-1);
    }

    /*WGK: during cluster operation, we want to periodically re-read
      the ACL, say on a HUP signal, or whenever it has changed. So,
      we first free up the structure.*/

    if(Hosts) {
      for(i = 0;i < NHosts;i++) if(Hosts[i].host) free (Hosts[i].host);
      free(Hosts);
      NHosts = 0;
    } 

    for(;;)
    {
      if(fgets(TmpStr,TmpStrSize - 2,QHosts) == NULL)
          break;
      {
	int j = 0;
      /*WGK: Skip over any white space before comments*/
      while(TmpStr[j] == ' ' | TmpStr[j] == '\t') {j++;}
      if(TmpStr[j] != '#' & TmpStr[j] != '\0')
        NHosts++;
      }
    }
    
    if((Hosts = (struct wkstruct *)malloc(sizeof(struct wkstruct) * NHosts)) == NULL)
    {
      fprintf(stderr,"ERROR allocating memory for hosts struct\n");
      exit(2);
    }
    
    if(fseek(QHosts,0, SEEK_SET) != 0)
    {
      fprintf(stderr,"ERROR seeking file %s\n",HostFile);
      exit(2);
    }
    for(i = 0;i < NHosts;i++)
    {
      Hosts[i].host = NULL;
      Hosts[i].load = 1e09;
    }
    
    for(i = 0;i < NHosts;)
    {
      int j = 0,k;

      if(fgets(TmpStr,TmpStrSize - 2,QHosts) == NULL)
          break;
      TmpStr[TmpStrSize-1] = '\0';
      {
	/*WGK: Skip over any white space before comments*/
	while(TmpStr[j] == ' ' | TmpStr[j] == '\t') {j++;}
	if(TmpStr[j] == '#' | TmpStr[j] == '\0'){
	  NHosts--;
	  continue;
	}
      }
      /*WGK: Truncate host at first white space character (e.g., newline.)*/
       
      for(k=j;k<strlen(TmpStr);k++) if(TmpStr[k] == ' ' | TmpStr[k] == '\t' | TmpStr[k] == '#' | TmpStr[k] == '\n' | TmpStr[k] == '\r') {
	TmpStr[k] = '\0';
	break;
      }

      /*WGK Don't do name lookup on null strings.*/
      if (!TmpStr[j]) {
	NHosts--;
	continue;
      }

      if((Hosts[i].host = strdup(canonicalhost(&TmpStr[j]))) == NULL)
      {
          printf("ERROR allocating memory for hosts struct\n");
          exit(2);
        }
      i++;
      
    }
    fclose(QHosts);
}

char *localhost(host)
char *host;
{
  /*Author: WGK*/
register char *i;
register char *lhost;
if(host==NULL)return(NULL);
lhost=strdup(host);
for(i=lhost;*i!='\0';++i) if (*i=='.') break;
*i='\0';
return(lhost);
}

char *canonicalhost(host)
char *host;
{
/* WGK 1995


This will save us problems when people upgrade their gethostname()
from host to host.domainname during an OS upgrade. It has the additional
advantage that it correctly distinguishes between otherwise identically
named hosts on different domains, in case anyone ever wants to try to
exploit that possible security hole,
and resolves aliases to a single official name for each host.*/
  struct hostent *thathost;
  if((thathost = gethostbyname(host))==NULL) {
    fprintf(stderr,"gethostbyname on %s returned error.\n",host);
    return(host);
  }
  return(thathost->h_aliases[0]);
}

char * mymalloc(n)
{
	register char *p;
	/*extern char *malloc();*/

	if ((p = malloc((size_t)n)) == NULL)
	  {
		fprintf(stderr,"Out of memory\n");
		exit(2);
	  }
	return p;
}



