/* cmd-inv-tag.c
 *
 ****************************************************************
 * Copyright (C) 2001, 2002, 2003  Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "config-options.h"
#include "hackerlab/cmd/main.h"
#include "tla/libarch/inv-tags.h"
#include "tla/libarch/cmd.h"
#include "tla/libarch/cmd-inv-tag.h"



static t_uchar * usage = "[options] file ...";
static t_uchar * version_string = (cfg__std__package " from regexps.com\n"
                                   "\n"
                                   "Copyright 2001, 2002, 2003 Tom Lord\n"
                                   "\n"
                                   "This is free software; see the source for copying conditions.\n"
                                   "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n"
                                   "PARTICULAR PURPOSE.\n"
                                   "\n"
                                   "Report bugs to " cfg__tla_bug_mail ".\n"
                                   "\n"
                                   cfg__std__release_id_string
                                   "\n");

#define OPTS(OP, OP2) \
  OP (opt_help_msg, "h", "help", 0, \
      "Display a help message and exit.") \
  OP (opt_long_help, "H", 0, 0, \
      "Display a verbose help message and exit.") \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string") \
  OP2 (opt_version, 0, 0, 0, "and exit.") \
  OP (opt_implicit, 0, "implicit", 0, \
      "Use the implicit tagging method.") \
  OP (opt_tagline, 0, "tagline", 0, \
      "Use the tagline tagging method (default).") \
  OP (opt_explicit, 0, "explicit", 0, \
      "Use the explicit tagging method.") \
  OP (opt_names, 0, "names", 0, \
      "Use the names tagging method.") \
  OP (opt_silent, 0, "silent", 0, \
      "No output -- exit status only.")

t_uchar arch_cmd_inv_tag_help[] = ("report the inventory tag for a file\n"
                                   "Print a file's inventory tag.\n");

enum options
{
  OPTS (OPT_ENUM, OPT_IGN)
};

static struct opt_desc opts[] =
{
  OPTS (OPT_DESC, OPT_DESC)
    {-1, 0, 0, 0, 0}
};



int
arch_cmd_inv_tag (t_uchar * program_name, int argc, char * argv[])
{
  int o;
  struct opt_parsed * option;
  int silent;
  enum arch_tagging_method method;
  t_uchar * answer;

  safe_buffer_fd (1, 0, O_WRONLY, 0);

  option = 0;

  silent = 0;
  method = arch_tagline_tagging;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, version_string, arch_cmd_inv_tag_help, opt_help_msg, opt_long_help, opt_version);
      if (o == opt_none)
        break;
      switch (o)
        {
        default:
          safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
          panic ("internal error parsing arguments");

        usage_error:
          opt_usage (2, argv[0], program_name, usage, 1);
          exit (1);

          /* bogus_arg: */
          safe_printfmt (2, "ill-formed argument for `%s' (`%s')\n", option->opt_string, option->arg_string);
          goto usage_error;

        case opt_implicit:
          method = arch_implicit_tagging;
          break;

        case opt_tagline:
          method = arch_tagline_tagging;
          break;

        case opt_explicit:
          method = arch_explicit_tagging;
          break;

        case opt_names:
          method = arch_names_tagging;
          break;

        case opt_silent:
          silent = 1;
          break;
        }
    }

  if (argc != 2)
    goto usage_error;

  answer = arch_inventory_tag (method, 0, argv[1], 0, 0, 0);

  if (!answer)
    {
      if (!silent)
        {
          safe_printfmt (2, "\n");
          safe_printfmt (2, "%s: untagged file\n", argv[0]);
          safe_printfmt (2, "  %s\n", argv[1]);
          safe_printfmt (2, "\n");
        }
      exit (1);
    }
  else
    {
      if (!silent)
        safe_printfmt (1, "%s\t%s\n", argv[1], answer);
      exit (0);
    }

  return 0;
}



/* tag: Tom Lord Wed May 14 08:06:44 2003 (inv-tag.c)
 */
