/* whats-missing.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/panic.h"
#include "tla/libarch/namespace.h"
#include "tla/libarch/patch-logs.h"
#include "tla/libarch/whats-missing.h"



rel_table
arch_whats_missing (t_uchar * tree_root, struct arch_archive * arch, t_uchar * version)
{
  rel_table has = 0;
  rel_table needs = 0;
  rel_table answer = 0;

  invariant (arch_valid_package_name (version, arch_no_archive, arch_req_version, 0));

  has = arch_log_ls (tree_root, arch->name, version, 0);
  needs = arch_archive_revisions (arch, version, 0);

  answer = rel_join (2, rel_join_output (2,0, -1), 0, 0, has, needs);

  rel_free_table (has);
  rel_free_table (needs);
  return answer;
}




/* tag: Tom Lord Sat May 24 23:01:13 2003 (whats-missing.c)
 */
