/* sample.c */

#include <stdio.h>
#include <stdlib.h>
#include "glpk.h"

int main(void)
{     LPX *lp;
      int rn[1+9], cn[1+9];
      double a[1+9], Z, x1, x2, x3;

s1:   lp = lpx_create_prob();
s2:   lpx_set_prob_name(lp, "sample");

s3:   lpx_add_rows(lp, 3);

s4:   lpx_set_row_name(lp, 1, "p");
s5:   lpx_set_row_bnds(lp, 1, LPX_UP, 0.0, 100.0);
s6:   lpx_set_row_name(lp, 2, "q");
s7:   lpx_set_row_bnds(lp, 2, LPX_UP, 0.0, 600.0);
s8:   lpx_set_row_name(lp, 3, "r");
s9:   lpx_set_row_bnds(lp, 3, LPX_UP, 0.0, 300.0);

s10:  lpx_add_cols(lp, 3);

s11:  lpx_set_col_name(lp, 1, "x1");
s12:  lpx_set_col_bnds(lp, 1, LPX_LO, 0.0, 0.0);
s13:  lpx_set_col_name(lp, 2, "x2");
s14:  lpx_set_col_bnds(lp, 2, LPX_LO, 0.0, 0.0);
s15:  lpx_set_col_name(lp, 3, "x3");
s16:  lpx_set_col_bnds(lp, 3, LPX_LO, 0.0, 0.0);

s17:  rn[1] = 1, cn[1] = 1, a[1] =  1.0;
s18:  rn[2] = 1, cn[2] = 2, a[2] =  1.0;
s19:  rn[3] = 1, cn[3] = 3, a[3] =  1.0;
s20:  rn[4] = 2, cn[4] = 1, a[4] = 10.0;
s21:  rn[5] = 3, cn[5] = 1, a[5] =  2.0;
s22:  rn[6] = 2, cn[6] = 2, a[6] =  4.0;
s23:  rn[7] = 3, cn[7] = 2, a[7] =  2.0;
s24:  rn[8] = 2, cn[8] = 3, a[8] =  5.0;
s25:  rn[9] = 3, cn[9] = 3, a[9] =  6.0;
s26:  lpx_load_mat3(lp, 9, rn, cn, a);

s27:  lpx_set_obj_dir(lp, LPX_MAX);

s28:  lpx_set_col_coef(lp, 1, 10.0);
s29:  lpx_set_col_coef(lp, 2, 6.0);
s30:  lpx_set_col_coef(lp, 3, 4.0);

s31:  lpx_simplex(lp);

s32:  Z = lpx_get_obj_val(lp);
s33:  lpx_get_col_info(lp, 1, NULL, &x1, NULL);
s34:  lpx_get_col_info(lp, 2, NULL, &x2, NULL);
s35:  lpx_get_col_info(lp, 3, NULL, &x3, NULL);

s36:  printf("\nZ = %g; x1 = %g; x2 = %g; x3 = %g\n", Z, x1, x2, x3);

s37:  lpx_delete_prob(lp);

      return 0;
}

/* eof */
