/* glpmat/create_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmat.h"

/*----------------------------------------------------------------------
-- create_mat() -- create sparse matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *create_mat(int m, int n);
--
-- *Description*
--
-- The routine create_mat() creates a real sparse matrix, which has m
-- rows and n columns. Initially the created matrix is empty, i.e. has
-- no elements.
--
-- It is allowed to specify m = 0 and/or n = 0.
--
-- *Returns*
--
-- The routine create_mat() returns a pointer to the created matrix. */

MAT *create_mat(int m, int n)
{     MAT *A;
      int m_max = 100, n_max = 100, i, j;
      if (!(m >= 0 && n >= 0))
         fault("create_mat: m = %d, n = %d; invalid dimension", m, n);
      A = umalloc(sizeof(MAT));
      A->pool = create_pool(sizeof(ELEM));
      while (m_max < m) m_max += m_max, insist(m_max > 0);
      while (n_max < n) n_max += n_max, insist(n_max > 0);
      A->m_max = m_max;
      A->n_max = n_max;
      A->m = m;
      A->n = n;
      A->row = ucalloc(1+m_max, sizeof(ELEM *));
      A->col = ucalloc(1+n_max, sizeof(ELEM *));
      for (i = 1; i <= m; i++) A->row[i] = NULL;
      for (j = 1; j <= n; j++) A->col[j] = NULL;
      return A;
}

/* eof */
