/* glpapi/glp_delete_prob.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_delete_prob - delete problem instance.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- void glp_delete_prob(LPI *lp);
--
-- *Description*
--
-- The routine glp_delete_prob deletes the problem instance, which
-- the parameter lp points to, freeing all the memory allocated to this
-- program object. */

void glp_delete_prob(LPI *lp)
{     delete_pool(lp->row_pool);
      delete_pool(lp->col_pool);
      delete_pool(lp->elem_pool);
      delete_pool(lp->str_pool);
      ufree(lp->row);
      ufree(lp->col);
      delete_avl(lp->row_tree);
      delete_avl(lp->col_tree);
      ufree(lp);
      return;
}

/* eof */
