/* glpapi.h */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#ifndef _GLPAPI_H
#define _GLPAPI_H

#include "glpavl.h"
#include "glpmat.h"
#include "glpstr.h"

typedef struct LPI LPI;
typedef struct LPIROW LPIROW;
typedef struct LPICOL LPICOL;

struct LPI
{     /* LP/MIP problem instance */
      POOL *row_pool;
      /* memory pool for allocating LPIROW objects */
      POOL *col_pool;
      /* memory pool for allocating LPICOL objects */
      POOL *elem_pool;
      /* memory pool for allocating constraint matrix elements */
      POOL *str_pool;
      /* memory pool for allocating segmented character strings */
      int check;
      /* data consistency checking flag */
      STR *name;
      /* problem name (1 to 255 chars) or NULL if problem has no name */
      int m_max;
      /* current dimension of array of row pointers; if necessary, this
         dimension is automatically increased */
      int n_max;
      /* current dimension of array of column pointers; if necessary,
         this dimension is automatically increased */
      int m;
      /* number of rows */
      int n;
      /* number of columns */
      LPIROW **row; /* LPIROW *row[1+m_max]; */
      /* array of row pointers; row[0] is not used; row[i] points to
         the i-th row (i = 1,...,m); row[m+1], ..., row[m_max] are
         reserved for new rows that can be added to the problem */
      LPICOL **col; /* LPICOL *col[1+n_max]; */
      /* array of column pointers; col[0] is not used; col[j] points to
         the j-th column (j = 1,...,n); col[n+1], ..., col[n_max] are
         reserved for new columns that can be added to the problem */
      AVLTREE *row_tree;
      /* row name search tree */
      AVLTREE *col_tree;
      /* column name search tree */
      double c0;
      /* constant term of the objective function */
      int sense;
      /* optimization sense:
         '-' - minimization
         '+' - maximization */
      int basis;
      /* basis status:
         '?' - basis is undefined
         'N' - basis is neither primal nor dual feasible
         'P' - basis is primal feasible, but dual infeasible
         'D' - basis is primal infeasible, but dual feasible
         'O' - basis is primal and dual feasible (optimal) */
      int status;
      /* solution status: */
#define GLP_UNDEF    0  /* solution is undefined */
#define GLP_OPT      1  /* solution is optimal */
#define GLP_FEAS     2  /* solution is feasible */
#define GLP_INFEAS   3  /* solution is infeasible */
#define GLP_NOFEAS   4  /* problem has no feasible solution */
#define GLP_UNBND    5  /* problem has unbounded solution */
#define GLP_INTOPT   6  /* solution is integer optimal */
#define GLP_INTSOL   7  /* solution is integer feasible */
#define GLP_DISINT   8  /* solution is integer infeasible */
#define GLP_NOINT    9  /* problem has no integer solution */
      double objval;
      /* value of the objective function */
};

struct LPIROW
{     /* row (auxiliary variable) */
      int seqn;
      /* row sequential number (1 to m) */
      STR *name;
      /* row name (1 to 255 chars) or NULL if row has no name */
      int type;
      /* row (auxiliary variable) type:
         'F' - free variable:    -inf <  x[k] <  +inf
         'L' - lower bound:      l[k] <= x[k] <  +inf
         'U' - upper bound:      -inf <  x[k] <= u[k]
         'D' - double bound:     l[k] <= x[k] <= u[k]
         'S' - fixed variable:   l[k]  = x[k]  = u[k] */
      double lb;
      /* lower bound; if row has no lower bound, lb is zero */
      double ub;
      /* upper bound; if row has no upper bound, ub is zero; in case
         of fixed auxiliary variable lb is equal to ub */
      double fctr;
      /* row scale factor */
      ELEM *ptr;
      /* pointer to the linked list of constraint coefficients placed
         in this row (this linked list is unordered) */
      int tagx;
      /* row (auxiliary variable) status:
         'B' - basic variable
         'L' - non-basic variable on its lower bound
         'U' - non-basic variable on its upper bound
         'F' - non-basic free variable
         'S' - non-basic fixed variable */
      double valx;
      /* row primal activity */
      double dx;
      /* row dual activity */
};

struct LPICOL
{     /* column (structural variable) */
      int seqn;
      /* column sequential number (1 to n) */
      STR *name;
      /* column name (1 to 255 chars) or NULL if column has no name */
      int kind;
      /* column (structural variable) kind:
         'C' - continuous variable
         'I' - integer variable */
      int type;
      /* column (structural variable) type:
         'F' - free variable:    -inf <  x[k] <  +inf
         'L' - lower bound:      l[k] <= x[k] <  +inf
         'U' - upper bound:      -inf <  x[k] <= u[k]
         'D' - double bound:     l[k] <= x[k] <= u[k]
         'S' - fixed variable:   l[k]  = x[k]  = u[k] */
      double lb;
      /* lower bound; if column has no lower bound, lb is zero */
      double ub;
      /* upper bound; if column has no upper bound, ub is zero; in case
         of fixed structural variable lb is equal to ub */
      double fctr;
      /* column scale factor */
      ELEM *ptr;
      /* pointer to the linked list of constraint coefficients placed
         in this column (this linked list is unordered) */
      double coef;
      /* coefficient of the objective function */
      int tagx;
      /* column (structural variable) status:
         'B' - basic variable
         'L' - non-basic variable on its lower bound
         'U' - non-basic variable on its upper bound
         'F' - non-basic free variable
         'S' - non-basic fixed variable */
      double valx;
      /* column primal activity */
      double dx;
      /* column dual activity */
};

#include "glpk.h"

#endif

/* eof */
